// Classe d'initialisation du module TArray (template Arrays)
#include "sopnamsp.h"
#include "machdefs.h"
#include "tarrinit.h"

#include "fioarr.h"
#include "fiospsqmtx.h"

/*!
   \defgroup TArray TArray module
   This module contains template arrays, matrices and vectors.
*/

/*!
  \class SOPHYA::TArrayInitiator
  \ingroup TArray
  Array Matrices and Vector initiator
*/

int TArrayInitiator::FgInit = 0;

// Module version number - 2.0 , Jul 2006
//   V= 2.04 , Jan/Fev 2007: Ajout TArray::ZeroSize() , RenewObjId() et methodes de cast (arrctcast.h)
//   V= 2.1 , Avr/Jul 2007: Constr.copie/extrac sous-tableaux thread-safe
//   V= 2.2 , Fev/Nars 2010: Tableaux en long double 
//   V= 2.3 , Juillet 2010: Ajout des matrices carres Diagonal, Triangulaire, Symmetrique
#define MOD_VERS   2.3

// Fonction d'enregistrement des handlers matrices carres speciales 
static void RegisterSSQM_PPFHandlers();

TArrayInitiator::TArrayInitiator()
  : SophyaInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules TArray
  

  PPRegister(FIO_TArray<uint_1>);
  DObjRegister(FIO_TArray<uint_1>, TArray<uint_1>);
  DObjRegister(FIO_TArray<uint_1>, TMatrix<uint_1>);
  DObjRegister(FIO_TArray<uint_1>, TVector<uint_1>);

  PPRegister(FIO_TArray<int_1>);
  DObjRegister(FIO_TArray<int_1>, TArray<int_1>);
  DObjRegister(FIO_TArray<int_1>, TMatrix<int_1>);
  DObjRegister(FIO_TArray<int_1>, TVector<int_1>);

  PPRegister(FIO_TArray<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TArray<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TMatrix<uint_2>);
  DObjRegister(FIO_TArray<uint_2>, TVector<uint_2>);

  PPRegister(FIO_TArray<int_2>);
  DObjRegister(FIO_TArray<int_2>, TArray<int_2>);
  DObjRegister(FIO_TArray<int_2>, TMatrix<int_2>);
  DObjRegister(FIO_TArray<int_2>, TVector<int_2>);

  PPRegister(FIO_TArray<uint_4>);
  DObjRegister(FIO_TArray<uint_4>, TArray<uint_4>);
  DObjRegister(FIO_TArray<uint_4>, TMatrix<uint_4>);
  DObjRegister(FIO_TArray<uint_4>, TVector<uint_4>);

  PPRegister(FIO_TArray<int_4>);
  DObjRegister(FIO_TArray<int_4>, TArray<int_4>);
  DObjRegister(FIO_TArray<int_4>, TMatrix<int_4>);
  DObjRegister(FIO_TArray<int_4>, TVector<int_4>);

  PPRegister(FIO_TArray<uint_8>);
  DObjRegister(FIO_TArray<uint_8>, TArray<uint_8>);
  DObjRegister(FIO_TArray<uint_8>, TMatrix<uint_8>);
  DObjRegister(FIO_TArray<uint_8>, TVector<uint_8>);

  PPRegister(FIO_TArray<int_8>);
  DObjRegister(FIO_TArray<int_8>, TArray<int_8>);
  DObjRegister(FIO_TArray<int_8>, TMatrix<int_8>);
  DObjRegister(FIO_TArray<int_8>, TVector<int_8>);

  PPRegister(FIO_TArray<r_4>);
  DObjRegister(FIO_TArray<r_4>, TArray<r_4>);
  DObjRegister(FIO_TArray<r_4>, TMatrix<r_4>);
  DObjRegister(FIO_TArray<r_4>, TVector<r_4>);

  PPRegister(FIO_TArray<r_8>);
  DObjRegister(FIO_TArray<r_8>, TArray<r_8>);
  DObjRegister(FIO_TArray<r_8>, TMatrix<r_8>);
  DObjRegister(FIO_TArray<r_8>, TVector<r_8>);

#ifdef SO_LDBLE128
  PPRegister(FIO_TArray<r_16>);
  DObjRegister(FIO_TArray<r_16>, TArray<r_16>);
  DObjRegister(FIO_TArray<r_16>, TMatrix<r_16>);
  DObjRegister(FIO_TArray<r_16>, TVector<r_16>);
#endif

  PPRegister(FIO_TArray< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TArray< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TMatrix< complex<r_4> >);
  DObjRegister(FIO_TArray< complex<r_4> >, TVector< complex<r_4> >);

  PPRegister(FIO_TArray< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TArray< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TMatrix< complex<r_8> >);
  DObjRegister(FIO_TArray< complex<r_8> >, TVector< complex<r_8> >);

#ifdef SO_LDBLE128
  PPRegister(FIO_TArray< complex<r_16> >);
  DObjRegister(FIO_TArray< complex<r_16> >, TArray< complex<r_16> >);
  DObjRegister(FIO_TArray< complex<r_16> >, TMatrix< complex<r_16> >);
  DObjRegister(FIO_TArray< complex<r_16> >, TVector< complex<r_16> >);
#endif

  RegisterSSQM_PPFHandlers();   // Enregistrement des gestionnaires PPF des matrices carrees speciales

  SophyaInitiator::RegisterModule("TArray", MOD_VERS);  // Module name and version number registration
}

TArrayInitiator::~TArrayInitiator()
{
  FgInit--;
}

// --- Fonction d'initialisation / enregistrement des handlers PPF pour matrices carres speciales 
static void RegisterSSQM_PPFHandlers()
{
// Enregistrement des gestionnaires PPF 
  PPRegister(FIO_SpecialSquareMatrix<uint_1>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_1>, DiagonalMatrix<uint_1>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_1>, LowerTriangularMatrix<uint_1>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_1>, SymmetricMatrix<uint_1>);

  PPRegister(FIO_SpecialSquareMatrix<uint_2>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_2>, DiagonalMatrix<uint_2>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_2>, LowerTriangularMatrix<uint_2>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_2>, SymmetricMatrix<uint_2>);

  PPRegister(FIO_SpecialSquareMatrix<uint_4>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_4>, DiagonalMatrix<uint_4>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_4>, LowerTriangularMatrix<uint_4>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_4>, SymmetricMatrix<uint_4>);

  PPRegister(FIO_SpecialSquareMatrix<uint_8>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_8>, DiagonalMatrix<uint_8>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_8>, LowerTriangularMatrix<uint_8>);
  DObjRegister(FIO_SpecialSquareMatrix<uint_8>, SymmetricMatrix<uint_8>);

  PPRegister(FIO_SpecialSquareMatrix<int_1>);
  DObjRegister(FIO_SpecialSquareMatrix<int_1>, DiagonalMatrix<int_1>);
  DObjRegister(FIO_SpecialSquareMatrix<int_1>, LowerTriangularMatrix<int_1>);
  DObjRegister(FIO_SpecialSquareMatrix<int_1>, SymmetricMatrix<int_1>);

  PPRegister(FIO_SpecialSquareMatrix<int_2>);
  DObjRegister(FIO_SpecialSquareMatrix<int_2>, DiagonalMatrix<int_2>);
  DObjRegister(FIO_SpecialSquareMatrix<int_2>, LowerTriangularMatrix<int_2>);
  DObjRegister(FIO_SpecialSquareMatrix<int_2>, SymmetricMatrix<int_2>);

  PPRegister(FIO_SpecialSquareMatrix<int_4>);
  DObjRegister(FIO_SpecialSquareMatrix<int_4>, DiagonalMatrix<int_4>);
  DObjRegister(FIO_SpecialSquareMatrix<int_4>, LowerTriangularMatrix<int_4>);
  DObjRegister(FIO_SpecialSquareMatrix<int_4>, SymmetricMatrix<int_4>);

  PPRegister(FIO_SpecialSquareMatrix<int_8>);
  DObjRegister(FIO_SpecialSquareMatrix<int_8>, DiagonalMatrix<int_8>);
  DObjRegister(FIO_SpecialSquareMatrix<int_8>, LowerTriangularMatrix<int_8>);
  DObjRegister(FIO_SpecialSquareMatrix<int_8>, SymmetricMatrix<int_8>);

  PPRegister(FIO_SpecialSquareMatrix<r_4>);
  DObjRegister(FIO_SpecialSquareMatrix<r_4>, DiagonalMatrix<r_4>);
  DObjRegister(FIO_SpecialSquareMatrix<r_4>, LowerTriangularMatrix<r_4>);
  DObjRegister(FIO_SpecialSquareMatrix<r_4>, SymmetricMatrix<r_4>);

  PPRegister(FIO_SpecialSquareMatrix<r_8>);
  DObjRegister(FIO_SpecialSquareMatrix<r_8>, DiagonalMatrix<r_8>);
  DObjRegister(FIO_SpecialSquareMatrix<r_8>, LowerTriangularMatrix<r_8>);
  DObjRegister(FIO_SpecialSquareMatrix<r_8>, SymmetricMatrix<r_8>);

  PPRegister(FIO_SpecialSquareMatrix< complex<r_4> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_4> >, DiagonalMatrix< complex<r_4> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_4> >, LowerTriangularMatrix< complex<r_4> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_4> >, SymmetricMatrix< complex<r_4> >);

  PPRegister(FIO_SpecialSquareMatrix< complex<r_8> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_8> >, DiagonalMatrix< complex<r_8> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_8> >, LowerTriangularMatrix< complex<r_8> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_4> >, SymmetricMatrix< complex<r_8> >);

#ifdef SO_LDBLE128
  PPRegister(FIO_SpecialSquareMatrix<r_16>);
  DObjRegister(FIO_SpecialSquareMatrix<r_16>, DiagonalMatrix<r_16>);
  DObjRegister(FIO_SpecialSquareMatrix<r_16>, LowerTriangularMatrix<r_16>);
  DObjRegister(FIO_SpecialSquareMatrix<r_16>, SymmetricMatrix<r_16>);

  PPRegister(FIO_SpecialSquareMatrix< complex<r_16> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_16> >, DiagonalMatrix< complex<r_16> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_16> >, LowerTriangularMatrix< complex<r_16> >);
  DObjRegister(FIO_SpecialSquareMatrix< complex<r_16> >, SymmetricMatrix< complex<r_16> >);
#endif 

  return;
}




// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static TArrayInitiator tarrayinit;

