#include "radutil.h"
#include <iostream>

// Appel : tjyk [z=redshift] [resol_arcmin]
 
int main(int narg, char* arg[])
{
  if (narg<2) {
    cout << " Usage: tjyk redshift [resol_arcmin] " << endl;
    return 1;
  }

  H21Conversions conv;
  
  double z = 0.;
  double resol = 10.;
  if (narg>1) z = atof(arg[1]);
  if (narg>2) resol = atof(arg[2]);

  conv.setRedshift(z);
  conv.setOmegaPixArcmin2(resol*resol);
  cout << " ------------------------------ H21Conversions ------------------------- " << endl;
  cout << "  Redshift=z= " << z << " Resol(arcmin)= " << resol << endl;
  cout << " H21Conversions: z=" << conv.getRedshift() << " Freq=" << conv.getFrequency()
       << " MHz , Lambda=" << conv.getLambda() << " m , OmegaPix=" << conv.getOmegaPix() << " srad" << endl;
  cout << "  toKelvin(1 Jy)= " << conv.toKelvin(1.) << "    toJansky(1 K)=" << conv.toJansky(1.) << endl;
  cout << "  Mean 21cm emission temperature= " << conv.T21cm_mK() << " milliKelvin " << endl;
  cout << " --------------------------------------------------------------- " << endl;

  return 0;
}
