# --------- File Linux_g_make.inc -------- 

#  Liste des librariries externes 
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) -lgfortran

#  Chemin et librairie pour PI 
PIINC = -I/usr/X11R6/include/
PILIBS = -L/usr/X11R6/lib/ -lXm -lXt -lX11 


#  Flag preprocesseur
CPPFLAGS = -I$(SOPHYAINCP) $(PIINC)
#  Def compilateur C et flags
CC = icc
# Replace [CNFPHFLF] by specific compilation flags below (done by configure)
CFLAGS = -fpic -O -g  CNFPHFLF 
#  Def compilateur C++ et flags
CXX =  icpc
CXXFLAGS = -fpic -O -frtti -g  CNFPHFLF 
CXXREP =
#  Compilo fortran
FC = ifort
FFLAGS =  
# Pour fabriquer les lib .a
AR = ar
ARFLAGS = -rcs


#  Ordres de compilation
CCOMPILE = $(CC) $(CPPFLAGS) $(CFLAGS) -c 
CXXCOMPILE = $(CXX) $(CPPFLAGS) $(CXXFLAGS) -c 
CXXCOMPILELIB = $(CXX) $(CPPFLAGS) $(CXXFLAGS) $(CXXREP) -c 
CXXCOMPILEPROG = $(CXX) $(CPPFLAGS) $(CXXFLAGS) $(CXXREP) -c 
FCCOMPILE = $(FC) $(FFLAGS) -c 

#  Extension de nom pour les librairies partagees
SLEXT = so
#  Fabrication de librairies partagees 
CMDSHLCXX = $(CXX) $(CXXFLAGS) $(CXXREP) -shared 


#  Liste de librairie de base, necessaire pour libsophya
SOPBASELIBS = -lpthread -lm -lc -ldl 
LIBFORT = -lgfortran

# --- Chemin pour l ensemble les librairies SOPHYA , +ExtLibs, +PI
SOPHYALIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST)  $(SOPBASELIBS)
SOPHYAEXTLIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST) $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLLIBLIST = -L$(SOPHYALIBP) $(SOPMODLIBLIST) $(SOPPILIBLIST) $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

SOPHYASLBLIST = -L$(SOPHYASLBP) -lsophya  $(SOPBASELIBS)
SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lPI -lextsophya -lsophya $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

#  Commande de link pour creation dexecutables
CXXLINK = $(CXX) $(CXXFLAGS)
CLINK = $(CC) $(CFLAGS)
FCLINK = $(FC) $(FFLAGS)

#  Commande de link pour creation de module pouvant etre charge dynamiquement
CXXDLL = $(CXX) $(CXXFLAGS) -shared
