#include <iostream>
#include <fstream>
#include <math.h>
#include <vector>
#include <string>
#include <stdexcept>

#include "slininterp.h"

using namespace std;

#include "array.h"
#include "tarrinit.h"
#include "sopnamsp.h"


//-------------------------------------------
// --- Test program for class SLinInterp1D : 
//-------------------------------------------

int main(int narg, char* arg[]) 
{ 
  cout << " +++++++  Programme test de la classe SLinInterp1D  +++++++ " << endl;
// To compile without SOPHYA : Comment the following  line 
  TArrayInitiator arrinit_;
  try {
    vector<double> xs;
    vector<double> ys;
    vector<double> yreg;
    
    double lesx[6] = {2.,3.,5.,9.5,11.,14.};
    for(int i=0;i<6; i++) {
      xs.push_back(lesx[i]);
      ys.push_back(lesx[i]*lesx[i]);
    }
        
    double xmin = 0.5;
    double xmax = 0.;
    for(int i=0; i<=12; i++) {
      xmax = xmin+i*0.05;
      yreg.push_back(sin(xmax)*cos(2.2*xmax));
    }

    {
      cout << " --- Creating file finterpXY.dat from xs,ys vectors ..." << endl;
      ofstream ofxy("finterpXY.dat");
      for(size_t i=0; i<xs.size(); i++) 
	ofxy << xs[i] << " " << ys[i] << " " << endl;
 
      cout << " --- Creating file finterpYR.dat from yreg vector ..."  << endl;
      ofstream ofy("finterpYR.dat");
      for(size_t i=0; i<yreg.size(); i++) 
	ofy << "  " << yreg[i] << endl;
    }
    SLinInterp1D interp(xs, ys);  // sans utilisation de X regularly spaced 
    SLinInterp1D interpR(xs, ys, 200);   // avec utilisation de X regularly spaced 
    SLinInterp1D interpYR(xmin, xmax, yreg);
    interp.Print(2);
    interpR.Print(2);
    interpYR.Print(2);

    cout << " ++++++++++++++++ From file +++++++++++++++++ " << endl;
    SLinInterp1D interpxyf, interpyf;
    string fname="finterpXY.dat";
    interpxyf.ReadXYFromFile(fname);
    fname="finterpYR.dat";
    interpyf.ReadYFromFile(fname,xmin,xmax);
    interpxyf.Print(2);
    interpyf.Print(2);
    cout << " ++++++++++++++++ Checking from file - without file +++++++++++++++++ " << endl;
    cout << " ++++++++++++ Interp With YRegular +++++++++++++ " << endl;

    for(int j=-3; j<=27; j++) {
      double x=j*0.025+xmin;
      double y = sin(x)*cos(2.2*x);
      cout << " sin()cos() -  J=" << j << " x=" << x << " y=" << y << "  yIterpolYR=" << interpYR(x) 
	   << "  interpYFile=  " << interpyf(x) << endl;
    }
    cout << " ++++++++++++++++ Interp With list of X,Y  +++++++++++++++ " << endl;
    for(int j=0; j<40; j++) {
      double x=j*0.5;
      cout << " J=" << j << " x=" << x << " y=" << x*x << "  yIterpol=" << interp(x) 
	   << "  interpxyf=" << interpxyf(x)  << "  yIterpolR=" << interpR(x) << endl; 
    }
    cout << " +++++++++++++++++++++++++++++++++++++++++++++++++++ " << endl;

  }
  catch(std::exception& exc) {
    cout << " Catched execption - msg=" << exc.what() << endl;
  }
  cout << " ---- FIN du programme test de la classe SLinInterp1D ---- " << endl;
  
}


