// Classe d'initialisation du module Samba 

#include "sopnamsp.h"
#include "sambainit.h"

/*!
   \defgroup Samba Samba module
   This module contains various classes for CMB analysis, such as
   spherical harmonic decomposition and synthesis
*/

/*!
  \class SOPHYA::SambaInitiator
  \ingroup Samba
  Array Matrices and Vector initiator
*/

int SambaInitiator::FgInit = 0;

// Module version number - 1.3 
// Aout 2010 : V=1.4 (introduction de la nouvelle classe LowerTriangularMatrix) 
#define MOD_VERS   1.4

SambaInitiator::SambaInitiator()
  : SkyMapInitiator()
{
  SambaInitiator::FgInit++;
  if (SambaInitiator::FgInit > 1)  return;
  ntinit = new NToolsInitiator;

  SophyaInitiator::RegisterModule("Samba", MOD_VERS);  // Module name and version number registration
}

SambaInitiator::~SambaInitiator()
{
  SambaInitiator::FgInit--;
  if (FgInit < 1)  delete ntinit;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static SambaInitiator s_sambainit_;

