// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

/* ---------------------------------------------------------- 
   Programme de lecture / calcul de visibilite multi-canaux 
   BAORadio -   LAL/IRFU      R. Ansari, C. Magneville
   V1 : Nov 2009
   ---------------------------------------------------------- */

// include standard c/c++
#include <iostream>
#include <string>
#include <exception>

// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"
#include "timestamp.h"
#include "strutilxx.h"
#include "tarrinit.h"
#include "histinit.h"

#include "brpaqu.h"
#include "brfitsrd.h"
#include "brproc.h"
#include "brviscalc.h"
#include "brdiskw.h"

#include "branap.h"



//----------------------------------------------------
//----------------------------------------------------
int main(int narg, char* arg[])
{

  TArrayInitiator  _inia;

  int rc = 0;
  try {
    // Decodage parametres 
    BRAnaParam par;
    cout << " ===> visimfib.cc: decoding command line arguments " << endl;
    rc = par.DecodeArgs(narg, arg);
    if (rc) return rc;
    rc = par.PaqSizeFromFits();
    if (rc) return rc;
    par.Print(cout);


    cout << " ---------- visimfib.cc Start - Action= " << par.action_ << " ------------- " << endl;
    ResourceUsage resu;

    cout << " visimfib: Creating MemZoneMgr/threads - PaqSz= " << par.paqsize_ << endl;

    RAcqMemZoneMgr mmgr(par.nzones_, par.dirlist_.size(), par.npaqinzone_, par.paqsize_);
    if (par.action_ == "cube3d")  mmgr.SetFinalizedMask((uint_4)MemZS_Saved);
    else  {
      if (par.nbcalgrp_==2) 
	mmgr.SetFinalizedMask((uint_4)MemZS_ProcA|(uint_4)MemZS_ProcB);
      else if (par.nbcalgrp_==3) 
	mmgr.SetFinalizedMask((uint_4)MemZS_ProcA|(uint_4)MemZS_ProcB|(uint_4)MemZS_ProcC);
      else if (par.nbcalgrp_==4) 
	mmgr.SetFinalizedMask((uint_4)MemZS_ProcA|(uint_4)MemZS_ProcB|(uint_4)MemZS_ProcC|(uint_4)MemZS_ProcD);
      else if (par.nbcalgrp_==5) 
	mmgr.SetFinalizedMask((uint_4)MemZS_ProcA|(uint_4)MemZS_ProcB|(uint_4)MemZS_ProcC|(uint_4)MemZS_ProcD|(uint_4)MemZS_ProcE);
      else if (par.nbcalgrp_==6) 
	mmgr.SetFinalizedMask((uint_4)MemZS_ProcA|(uint_4)MemZS_ProcB|(uint_4)MemZS_ProcC|
                              (uint_4)MemZS_ProcD|(uint_4)MemZS_ProcE|(uint_4)MemZS_ProcF);
      else mmgr.SetFinalizedMask((uint_4)MemZS_ProcA);	
    }
    BRMultiFitsReader reader(mmgr, par.dirlist_, true, par.imin_, par.imax_, par.istep_);
    reader.SetPrintLevel(par.prtlevel_);

    /*    BRVisibilityCalculator proc(mmgr, par.outpath_, par.nmean_, par.nthreads_);
    proc.SelectFreqBinning(par.freqmin_, par.freqmax_, par.nbinfreq_);  */
    BRVisCalcGroup procg(par.nbcalgrp_, mmgr, par.outpath_, par.nmean_, par.nthreads_);
    procg.SelectFreqBinning(par.freqmin_, par.freqmax_, par.nbinfreq_);

    if (par.action_ == "viscktt")  procg.ActivateTimeTagCheck(par.TotalNPaquets());
    BRMeanSpecCalculator procms(mmgr, par.outpath_, par.nmean_);

    FitsCubeWriter wrt(mmgr, par.outpath_, par.nbloc_);
    //    BRBaseProcessor proc(mmgr);

    cout << " visimfib: Starting threads (reader procVisi) ... " << endl;
    reader.start();
    if (par.action_ == "cube3d")   wrt.start();
    else if (par.action_ == "mspec")   procms.start();
    else  procg.start();
    usleep(200000);
    reader.join();
    if (par.action_ == "cube3d")  wrt.join();
    else if (par.action_ == "mspec")  procms.join();
    else procg.join();
    mmgr.Print(cout);
    cout << resu ; 
  }
  catch (std::exception& sex) {
    cerr << "\n visimfib.cc std::exception :"  << (string)typeid(sex).name() 
	 << "\n msg= " << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " visimfib.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> visimfib.cc ------- END ----------- RC=" << rc << endl;
  return rc;

}


