#include <stdlib.h>

#include "brparam.h"
#include "strutilxx.h"
#include "bracqvers.h"

#ifndef BRSPORTID
#define BRSPORTID 6912
#endif

/* --Methode-- */
ADCBoardDesc::ADCBoardDesc(int id, string sbid, string cyc_firmw, string str1_firmw, string str2_firmw)
  : id_(id), sbid_(sbid), cyclone_firmware_(cyc_firmw), stratix1_firmware_(str1_firmw), stratix2_firmware_(str2_firmw)
{
  
}

/* --Methode-- */
ADCBoardDesc::ADCBoardDesc(ADCBoardDesc const& bdes)
  : id_(bdes.id_), sbid_(bdes.sbid_), cyclone_firmware_(bdes.cyclone_firmware_), 
    stratix1_firmware_(bdes.stratix1_firmware_), stratix2_firmware_(bdes.stratix2_firmware_)
{
}

/* --Methode-- */
ADCBoardDesc& ADCBoardDesc::Set(ADCBoardDesc const & bdes)
{
  id_ = bdes.id_;
  sbid_ = bdes.sbid_;
  cyclone_firmware_ = bdes.cyclone_firmware_;
  stratix1_firmware_ = bdes.stratix1_firmware_;
  stratix2_firmware_ = bdes.stratix2_firmware_;
  return(*this);
}

/* --Methode-- */
ostream& ADCBoardDesc::Print(ostream& os)
{
  os << "ADCBoard#" << id_ << "(" << sbid_ << ") Cyclone:" << cyclone_firmware_ 
     << " Stratix1: " << stratix1_firmware_ << " Stratix2: " << stratix2_firmware_ << endl;
  return os;
}

/* --Methode-- */
BRConfList::BRConfList()
  : basedir_("./")
{
}

/* --Methode-- */
BRConfList::BRConfList(string basedir)
  : basedir_(basedir)
{
}

/* --Methode-- */
BRConfList::BRConfList(string basedir, vector<ADCBoardDesc> boards)
  : basedir_(basedir), boards_(boards)
{
  size_t len = basedir_.length();
  if ((len>1)&&(basedir_[len-1]!='/')) basedir_ += '/';
}

/* --Methode-- */
BRConfList::BRConfList(BRConfList const & cf)
  : basedir_(cf.basedir_), boards_(cf.boards_)
{
}

/* --Methode-- */
void BRConfList::SetBaseDirectory(string basedir)
{
  basedir_=basedir;
  size_t len = basedir_.length();
  if ((len>1)&&(basedir_[len-1]!='/')) basedir_ += '/';
}

/* --Methode-- */
void BRConfList::Set(BRConfList const & cf)
{
  basedir_=cf.basedir_;
  boards_=cf.boards_;
}

/* --Methode-- */
ostream& BRConfList::Print(ostream& os)
{
  os << " ----- BRConfList:: BaseDir:" << basedir_ << " NBoards= " << boards_.size() << endl;
  for(size_t k=0; k<boards_.size(); k++)  boards_[k].Print(os);
  return os;
}

/* --Methode-- */
void BRConfList::ReadDCFile(string file)
{
  //  A FAIRE 
}

// Classe qui memorise tous les parametres importants de l'acquisition

/* --Methode-- */
BRParList::BRParList(string acqmod, string fibres,unsigned int paqsz, 
		     unsigned int dmaszkb, int nfiles, int nblocfile,
		     string outpath, uint_4 nzon , uint_4 npaqzon)
{
  AcqMode=acqmod;
  fgdatafft=false;
  fgsinglechannel=false;

  FiberListS=fibres;
  NbFibers=0;
  for (int fib=0; fib<PMAXNBFIBRES;fib++)  FiberNum[fib]=0;
  PaqSize=paqsz;
  dmasizekb=dmaszkb;

  NbFiles=nfiles;
  NBlocPerFile=nblocfile;
  OutPathName=outpath;

  nZones=nzon;
  nPaqZone=npaqzon;

  swapall=BR_Copy;
  savesigfits=true;
  fgnulldev4fits=false;

  fg_hard_ctrlc=false;

  fgreducpsize=false;
  reducneedcopy=false;
  pqreducmode=BR_CopyRA;
  redpqsize=PaqSize;
  reducoffset=0;

  tcpportid=BRSPORTID;
  pci2eth_fgdirect=false;
  ethr_nlink = 0;

  skysource="";

//  --- variables de controle pour le monitoring 
  fgdoProc=false;
  nmeanProc=512;
  stepProc=5;
  nmaxProc=0;
//  --- variables de controle pour le calcul des visibilites  
  fgdoVisiC = false;
  nmeanVisiC=1024;
  nbcalgrpVisiC=1;
  nthrVisiC=1;
  freqminVisiC=freqmaxVisiC=0;
  nbinfreqVisiC=1;  

// Autres variables / variables speciales 
  monothr=false;
  activate_pattern=false;
  nopciLossRate=0.;

  Decode();    // On decode et on complete les parametres 
}

/* --Methode-- */
BRParList::BRParList(BRParList const & p)
{
  Set(p);
}

/* --Methode-- */
void BRParList::Set(BRParList const & p)
{
  AcqMode=p.AcqMode;
  fgdatafft=p.fgdatafft;
  fgsinglechannel=p.fgsinglechannel;

  FiberListS=p.FiberListS;
  NbFibers=p.NbFibers;
  for (int fib=0; fib<PMAXNBFIBRES;fib++)  FiberNum[fib]=p.FiberNum[fib];

  PaqSize=p.PaqSize;
  dmasizekb=p.dmasizekb;

  NbFiles=p.NbFiles;
  NBlocPerFile=p.NBlocPerFile;
  OutPathName=p.OutPathName;

  nZones=p.nZones;
  nPaqZone=p.nPaqZone;

  swapall=p.swapall;
  savesigfits=p.savesigfits;
  fgnulldev4fits=p.fgnulldev4fits;
  fg_hard_ctrlc=p.fg_hard_ctrlc;
  fgnulldev4fits=p.fgnulldev4fits;

  fgreducpsize=p.fgreducpsize;
  reducneedcopy=p.reducneedcopy;
  pqreducmode=p.pqreducmode;
  redpqsize=p.redpqsize;
  reducoffset=p.reducoffset;

  tcpportid=p.tcpportid;
  pci2eth_fgdirect=p.pci2eth_fgdirect;
  eths_targets=p.eths_targets;
  ethr_nlink=p.ethr_nlink;

  skysource=p.skysource;
  
  fgdoProc=p.fgdoProc;
  nmeanProc=p.nmeanProc;
  stepProc=p.stepProc;
  nmaxProc=p.nmaxProc;

  monothr=p.monothr;
  activate_pattern=p.activate_pattern;

  nopciLossRate=p.nopciLossRate;
  return;
}

/* --Methode-- */
void BRParList::ReadDCFile(string file)
{
  DataCards conf(file);
  FiberListS= conf.SParam("fibres",0,"1");
  OutPathName= conf.SParam("outpathname",0,"TstAcq");
  skysource= conf.SParam("skysource",0,"");
  PaqSize=(uint_4)conf.IParam("paqsize",0,16424);
  dmasizekb =(uint_4) conf.IParam("dmasizekb",0,32);
  NbFiles=conf.IParam("nbfiles",0,1);
  NBlocPerFile=conf.IParam("nblocperfile",0,10);
  AcqMode =conf.SParam("acqmode",0,"std");
  nZones=(uint_4)conf.IParam("memmgr",0,4);
  nPaqZone=(uint_4)conf.IParam("memmgr",1,128);
  if (conf.HasKey("reducpaqsz")) {  // reduction des tailles de paquets
    fgreducpsize=true;
    redpqsize=(uint_4)conf.IParam("reducpaqsz",0,PaqSize/4);
    reducoffset=(uint_4)conf.IParam("reducpaqsz",1,0);
  }
  // Mot cle pour le mode envoi-reception sur ethernet 
  tcpportid=conf.IParam("tcpportid",0,BRSPORTID);
  if (conf.HasKey("pci2ethdirect"))  pci2eth_fgdirect = true;   // Transfer direct DMA -> Ethernet
  if (conf.HasKey("ethrtargets")) {    // Machines destinations des paquets 
    for(int it=0; it<conf.NbParam("ethrtargets"); it++) 
      eths_targets.push_back(conf.SParam("ethrtargets",it));
  }
  ethr_nlink=conf.IParam("ethrnlink",0,0);   // Nombre de sources de paquets en reception ethernet 

  //  Parametre de controle du monitoring 
  if (conf.HasKey("monitor")) {
    fgdoProc=true;
    nmeanProc=conf.IParam("monitor",0,512);
    stepProc=conf.IParam("monitor",1,10);
    nmaxProc=conf.IParam("monitor",2,0);
  }
  // Parametres pour le calcul des visibilites - le flag fgdoVisiC ne peut etre active 
  // qu'avec l'option de ligne de commande de mfacq 
  if (conf.HasKey("visicalc")) {
    nmeanVisiC=conf.IParam("visicalc",0,1024);
    nbcalgrpVisiC=conf.IParam("visicalc",1,1);
    nthrVisiC=conf.IParam("visicalc",2,1);
  }
  if (conf.HasKey("visicfreq")) {
    freqminVisiC=conf.IParam("visicfreq",0,0);
    freqmaxVisiC=conf.IParam("visicfreq",1,0);
    nbinfreqVisiC=conf.IParam("visicfreq",2,1);
  }

  nopciLossRate=conf.DParam("nopcilossrate",0,0.);
  fg_hard_ctrlc=conf.HasKey("hard_ctrlc");
  if (conf.HasKey("nosavesigfits"))  savesigfits=false;
  Decode();
}

/* --Methode-- */
void BRParList::Decode() 
{
  vector<string> fiblist;
  FillVStringFrString(FiberListS, fiblist, ',');
  NbFibers=fiblist.size();
  for (int fib=0; fib<fiblist.size(); fib++) {
    FiberNum[fib]=atoi(fiblist[fib].c_str()); 
  }
  if (OutPathName == "/dev/null") { 
    fgnulldev4fits=true;
  }
  else { 
    size_t len = OutPathName.length();
    if ((len>1)&&(OutPathName[len-1]!='/')) OutPathName+='/';
    fgnulldev4fits=false;
  }
  string acqmode = AcqMode;
  fgdatafft=false;  fgsinglechannel=false;
  reducneedcopy=false;  pqreducmode=BR_TwoChanReduc;
  if ((acqmode == "std")||(acqmode=="raw2c"))   swapall = BR_Copy ;  
  if (acqmode == "nosw")   swapall = BR_Copy ;
  if (acqmode == "nof")  { swapall = BR_Copy ; savesigfits = false; }
  if (acqmode == "fft1c")  { swapall = BR_FFTOneChan; reducneedcopy=true;  pqreducmode=BR_OneChanReducK0; }
  if (acqmode == "fft2c")  { swapall = BR_FFTTwoChan;  reducneedcopy=true;  pqreducmode=BR_TwoChanReducK0; }
  if (acqmode == "fft1cnof")  
    { swapall = BR_FFTOneChan;  savesigfits = false; reducneedcopy=true;  pqreducmode=BR_OneChanReducK0;  }
  if (acqmode == "fft2cnof")  
    { swapall = BR_FFTTwoChan;  savesigfits = false; reducneedcopy=true;  pqreducmode=BR_TwoChanReducK0; }
  if (acqmode == "mono")  { monothr = true;   swapall = BR_Copy; }
  if (acqmode == "monodirect")  { monothr = true;  swapall =  BR_CopyHDR;}
  if (acqmode == "patmonodirect")  { monothr = true;  swapall =  BR_CopyHDR; activate_pattern=true; }
  if (acqmode == "patmono")  { monothr = true;   swapall = BR_Copy; activate_pattern=true; }
  if (acqmode == "patnof")  { savesigfits = false; swapall = BR_Copy; activate_pattern=true; }
  if (acqmode == "pattern")  { savesigfits = true; swapall = BR_Copy; activate_pattern=true; }

  if (acqmode == "swapall")  swapall = BR_SwapAll;
  if (acqmode == "fft1csw") 
    { swapall = BR_FFTOneChanSwapAll;  reducneedcopy=true;  pqreducmode=BR_OneChanReducK0; }
  if (acqmode == "fft2csw") 
    { swapall = BR_FFTTwoChanSwapAll;  reducneedcopy=true;  pqreducmode=BR_TwoChanReducK0; }
  if (acqmode == "fft1cswnof")  
    { swapall = BR_FFTOneChanSwapAll;  savesigfits = false; reducneedcopy=true;  pqreducmode=BR_OneChanReducK0; } 
  if (acqmode == "fft2cswnof")  
    { swapall = BR_FFTTwoChanSwapAll;  savesigfits = false; reducneedcopy=true;  pqreducmode=BR_TwoChanReducK0; }
  if ((acqmode == "swh") || (acqmode == "mxs") || (acqmode == "monoswh") )  swapall = BR_SwapHDR;
  if ((acqmode == "swapallnof") || (acqmode == "mxs") )  savesigfits = false;
  if (acqmode == "monoswh")  { monothr = true;   swapall = BR_SwapHDR;; }
  if (acqmode == "monosw")  { monothr = true;   swapall = BR_SwapAll; }

  if (acqmode == "swap32")   swapall = BR_Swap32 ;
  if (acqmode == "nof32")   { swapall = BR_Swap32 ; savesigfits = false; }
  if (acqmode == "fft1c32")  
    { swapall = BR_FFTOneChanSwap32; reducneedcopy=true;  pqreducmode=BR_OneChanReducK0; }
  if (acqmode == "fft2c32")  
    { swapall = BR_FFTTwoChanSwap32; reducneedcopy=true;  pqreducmode=BR_TwoChanReducK0; }
  if (acqmode == "fft1cnof32")  
    { swapall = BR_FFTOneChanSwap32;  savesigfits = false; reducneedcopy=true;  pqreducmode=BR_OneChanReducK0; }
  if (acqmode == "fft2cnof32")  
    { swapall = BR_FFTTwoChanSwap32;  savesigfits = false; reducneedcopy=true;  pqreducmode=BR_TwoChanReducK0; }

  if ((swapall==BR_FFTTwoChan)||(swapall==BR_FFTTwoChanSwapAll)||(swapall==BR_FFTTwoChanSwap32)) {
    fgdatafft=true;  
  }
  if ((swapall==BR_FFTOneChan)||(swapall==BR_FFTOneChanSwapAll)||(swapall==BR_FFTOneChanSwap32)) {
    fgdatafft=true;  fgsinglechannel=true; 
  }
  
  if (fgreducpsize) {
    if (redpqsize>=PaqSize) fgreducpsize=false;
    else {
      if(reducoffset>(PaqSize-redpqsize)/2) reducoffset=(PaqSize-redpqsize)/2;
    }
  }
}

/* --Methode-- */
ostream& BRParList::Print(ostream& os) 
{  
  os << " ------ BRParList::Print() ----- " << endl;
  os << " FiberListS=" << FiberListS ;
  os << " PaqSize=" <<PaqSize;
  os << " DMA_Size_kb=" <<dmasizekb << endl;
  os << " AcqMode="<<AcqMode;
  os << " Type of acquisition :" << BRPaquet::FmtConvToString( swapall) << endl;
  os << " SkySource=" << skysource;
  os << " NbFiles="<<NbFiles;
  os << " NBlocPerFile="<<NBlocPerFile;
  os << " OutPathName="<<OutPathName << endl;
  os << " MemMgr: nZones="<<nZones;
  os << " nPaqZone="<<nPaqZone<<endl;
  if (fgreducpsize) {
    os << " PaquetSize Reduction, ReducedSize=" << redpqsize << " Offset=" << reducoffset << endl;
  }
  if (eths_targets.size()>0)   {
    cout << " DMA->Ethernet NbTargets=" << eths_targets.size() 
	 << ((pci2eth_fgdirect)?" (DirectTransferMode) " : " " ) << " :";
    for(size_t it=0; it<eths_targets.size(); it++) cout << eths_targets[it] << " , ";
    cout << endl;
  }
  cout << " TCP-PortId=" << tcpportid << " EthernetRead NbSources (=NbLinks)= " << ethr_nlink << endl;
  if (fgdoProc>0) 
    os << " Monitoring  NMeanProc=" << nmeanProc << " StepProc=" << stepProc << " NMaxProc=" << nmaxProc << endl;
  else os << " No monotoring thread " << endl;
  if (fgdoVisiC) {
    os << " Visibility calculation, nbCalGrp=" << nbcalgrpVisiC << " NThr/VisCal=" << nthrVisiC << endl;
    os << " ... VisiCalc FrequencyBinning FreqMin= " << freqminVisiC << " FreqMax= " << freqmaxVisiC 
       << " NBinFreq= " << nbinfreqVisiC<< endl;
  }
  os << " fg_hard_ctrlc=" << ((fg_hard_ctrlc)?"true":"false");
  os << " Save to fits " << ((savesigfits)?"true":"false") << endl;
  os << " monothr y(1)/n(0) " << ((monothr)?"true":"false"); 
  os << " ActivatePattern " << ((activate_pattern)?"true":"false") <<  endl;
  
  return os;
}


//-------------------- Classe BRAcqConfig -----------------------

BRParList* BRAcqConfig::param_=NULL;
BRConfList* BRAcqConfig::config_=NULL;

/* --Methode-- */
BRAcqConfig::BRAcqConfig()
{
  if (param_==NULL)  param_ = new BRParList;  
  if (config_==NULL) config_ = new BRConfList;
}

/* --Methode-- */
ostream& BRAcqConfig::Print(ostream& os)
{ 
  os << " ------------  BAORadio Acq Run/Configuration -------- " << endl;
  config_->Print(os);
  param_->Print(os); 
  os << " ----------------------------------------------------- " << endl;
}

/* --Methode-- */
int BRAcqConfig::CreateOutputDirectories()
{
  char cmd[1024];
  if (param_->fgnulldev4fits!=true) {
    sprintf(cmd,"mkdir %s%s",config_->BaseDirectory().c_str(), param_->OutPathName.c_str());
    if (system(cmd) < 0) {
      cout << "CreateOutputDirectories()/Error: Can not create subdirectory " 
	   << cmd << " -> stop" << endl;
      return 2;
    }
    cout << "CreateOutputDirectories() - Executed command " << cmd << endl;
    
    memset(cmd,0,1024); 
    for (int  i= 0; i< NFibers() ; i++)  {
      sprintf(cmd,"mkdir %s%s/Fiber%d",config_->BaseDirectory().c_str(), param_->OutPathName.c_str(),param_->FiberNum[i]);
      if (system(cmd) < 0) {
	cout << "CreateOutputDirectories()/Error: Can not create subdirectory " 
	     << cmd << " -> stop" << endl;
	return 3;
      }
      else cout << "CreateOutputDirectories() - Executed command " << cmd << endl;
    }
  }
  else {
    string ProcPathName = "./XZXZXZX/";
    cout << " Using " << ProcPathName << " for other processed files ... " << endl;
    char cmd[512];
    sprintf(cmd,"mkdir %s",ProcPathName.c_str());
    if (system(cmd) < 0) {
      cout << "CreateOutputDirectories()/Error: Can not create subdirectory ./XZXZXZX/" 
	   << "-> stop" << endl;
      return 3;
    }
    else cout << "CreateOutputDirectories() - Executed command " << cmd << endl;
  }
  return 0;
}

/* --Methode-- */
string BRAcqConfig::OutputDirectoryFib(int ifib)
{
  char buff[24];
  sprintf(buff,"Fiber%d/",param_->FiberNum[ifib]);
  return ( config_->BaseDirectory() + param_->OutPathName + buff );
}
