#ifndef  RARDFITS_H_SEEN
#define  RARDFITS_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classes de threads pour lecture fichiers fits BAORadio
//----------------------------------------------------------------

#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>

#include "brpaqu.h"
#include "minifits.h"

using namespace std;

//  ATTENTION cette definition (MAXANAFIB) se trouve dans plusieurs fichiers 
#ifndef MAXANAFIB 
#define MAXANAFIB  32
#endif

//-------------------------------------------------------
// Classe thread de lecture des fichiers data BAORadio 
//  BRMultiFitsReader : Lecture multi-fibres 
//-------------------------------------------------------

class BRMultiFitsReader : public SOPHYA::ZThread {
public:	
  BRMultiFitsReader(RAcqMemZoneMgr& mem, vector<string>& dirs, 
		    bool rdsamefc=true, uint_4 imin=0, uint_4 imax=0, uint_4 istep=1); 

  virtual void run(); 
  inline void Stop() { stop_ = true; } 
  inline void STOP() { stop_ = true; }	

  inline int SetPrintLevel(int lev=0, uint_8 prtmodulo=50000) 
    { prtlev_=lev;   prtmodulo_=prtmodulo;  return 0; }

protected:
  bool ReadNextAllFibers();      // Renvoie true si probleme 
  bool ReadNext(int fib);   // Renvoie true si probleme 
  // Permet d'avancer d'un paquet dans la zone - renvoie true si probleme
  inline bool MoveToNextTarget()  {
    if ((mmbuf_ == NULL )||(targ_npaq_ >= max_targ_npaq)) 
      if (MZoneManage()) return true;
    targ_npaq_++;
    return false;
  }
  inline Byte* GetPaquetTarget(int numfib)  {
    if ((mmbufib_[numfib] == NULL )||(targ_npaq_ > max_targ_npaq)||(targ_npaq_ == 0))  return NULL; 
    Byte* rb=mmbufib_[numfib]+(targ_npaq_-1)*packsize_;
    return rb;
  }
  bool MZoneManage(bool clean=false);  // Renvoie true si probleme

  RAcqMemZoneMgr& memgr_;
  vector<string> dirs_;  //  repertoires donnees chaque fibre 
  bool stop_;
  bool rdsamefc_;  // if true, read paquets with same value of FrameCounter on different fibers
  uint_4 imin_, imax_, istep_; 
  uint_8 totnbytesrd_;
  uint_8 totsamefc_;   // nombre total de paquets avec meme framecounter  
  MiniFITSFile mff_[MAXANAFIB];
  vector<uint_4> vfilenum_;
  vector<uint_4> vfpos_; 
  vector<BRPaquet> vpaq_; 
  vector<BRPaqChecker> vpchk_;
  vector<uint_8> curfc_;       // Numeros des FrameCounter des paquets courants
  vector<uint_8> totnpqrd_;    // nombre total de paquets lus / fibre 
  vector<uint_8> totnpqok_;    // nombre total de paquets OK / fibre  

  uint_4 packsize_;
  int mid_;  // Identificateur zone memoire
  uint_4 targ_npaq_;  // Numero de paquet dans une seule zone memoire 
  uint_4 max_targ_npaq; // =  mmgr.NbPaquets() = Max de targ_npaq_
  Byte* mmbuf_;  // Pointeur zone memoire rendu par RAcqMemZoneMgr 
  Byte* mmbufib_[MAXANAFIB];  // Pointeurs zone memoire de chaque fibre rendu par RAcqMemZoneMgr 

  int prtlev_;         // print level 
  uint_8 prtmodulo_;   // print periodicity (modulo) 
};

//-------------------------------------------------------
// Classe thread de lecture des fichiers (mini)fits
//-------------------------------------------------------

class BRFitsReader : public SOPHYA::ZThread {
public:	
  BRFitsReader(RAcqMemZoneMgr& mem, vector<string>& infiles, bool fgnotrl=false); 

  virtual void run(); 
  inline void Stop() { stop_ = true; } 
  inline void STOP() { stop_ = true; }	

protected:
  RAcqMemZoneMgr& memgr;
  vector<string> infiles_;
  bool fgnotrl_;
  bool stop_;  
};

#endif
