// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

/* ---------------------------------------------------------- 
   Programme de lecture multifibres, calcul de spectres 
   BAORadio -   LAL/IRFU      R. Ansari, C. Magneville
   Septembre 2010 
   ---------------------------------------------------------- */

// include standard c/c++
#include <iostream>
#include <string>
#include <exception>

// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"
#include "timestamp.h"
#include "strutilxx.h"
#include "tarrinit.h"
#include "histinit.h"

#include "brpaqu.h"
#include "brfitsrd.h"
#include "brproc.h"
#include "brdiskw.h"

#include "branap.h"



//----------------------------------------------------
//----------------------------------------------------
int main(int narg, char* arg[])
{

  TArrayInitiator  _inia;

  int rc = 0;
  try {
    // Decodage parametres 
    BRAnaParam par;
    par.action_="mspec";
    cout << " ===> specmfib.cc: decoding command line arguments " << endl;
    rc = par.DecodeArgs(narg, arg);
    if (rc) return rc;
    rc = par.PaqSizeFromFits();
    if (rc) return rc;
    par.Print(cout);
    if ((par.action_!="cube3d")&&(par.action_!="mspec")) {
      cout << " !!! specmfib.cc  BAD action = " << par.action_ << " possible values: mspec,cube3d" << endl;
      return 5;
    }   

    cout << " ---------- specmfib.cc Start - Action= " << par.action_ << " ------------- " << endl;
    ResourceUsage resu;
    BRPaquet paq(par.paqsize_);
    uint_4 procsz=sizeof(float)*(paq.DataSize()+4);
    if ((par.fgdatafft_)||(par.action_=="cube3d")) procsz = 0;
    cout << " specmfib: Creating MemZoneMgr/threads - PaqSz= " << par.paqsize_ 
	 << " ProcPaqSz=" << procsz << endl;
    RAcqMemZoneMgr mmgr(par.nzones_, par.dirlist_.size(), par.npaqinzone_, par.paqsize_, procsz);
    if (par.action_ == "cube3d")  mmgr.SetFinalizedMask((uint_4)MemZS_Saved);
    else {
      if (par.fgdatafft_)  mmgr.SetFinalizedMask((uint_4)MemZS_ProcA);
      else mmgr.SetFinalizedMask((uint_4)MemZS_ProcB);
    }
    BRMultiFitsReader reader(mmgr, par.dirlist_, par.rdsamefc_, par.imin_, par.imax_, par.istep_);
    reader.SetPrintLevel(par.prtlevel_,par.prtmodulo_);

    BRMeanSpecCalculator procms(mmgr, par.outpath_, par.nmean_, par.fgdatafft_, par.fgsinglechannel_);
    BRFFTCalculator procfft(mmgr, par.fgsinglechannel_);
    if (!par.fgdatafft_) procms.SetMemZAction(MemZA_ProcB);

    FitsCubeWriter wrt(mmgr, par.outpath_, par.nbloc_);

    cout << " specmfib: Starting threads (reader meanSpecCalculator ...) ... " << endl;
    reader.start();
    if (par.action_ == "cube3d")   wrt.start();
    else {  // Calcul spectre moyenne 
      if (!par.fgdatafft_)  procfft.start(); 
      procms.start();
    }
    usleep(200000);
    reader.join();
    if (par.action_ == "cube3d")  wrt.join();
    else {
      if (!par.fgdatafft_)  procfft.join(); 
      procms.join();
    }
    mmgr.Print(cout);
    cout << resu ; 
  }
  catch (std::exception& sex) {
    cerr << "\n specmfib.cc std::exception :"  << (string)typeid(sex).name() 
	 << "\n msg= " << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " specmfib.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> specmfib.cc ------- END ----------- RC=" << rc << endl;
  return rc;

}


