#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "courbe_nb.h"

/*==============================================================*/
FILE *CreCourbe(const char *str)
/*
Pour ouvrir le fichier COURBE_NB_FILE avec le nom "str".
  Permet de mettre plusieurs etoiles dans le meme fichier.
*/
{
if(COURBE_NB_FILE!=NULL) {
  printf("CreCourbe_Erreur: Fichier Courbe non ferme!\n");
  fclose(COURBE_NB_FILE);
}
COURBE_NB_FILE = fopen(str,"w");
return COURBE_NB_FILE;
}

/*==============================================================*/
FILE *CreCourbe(int et)
{
/*
Pour ouvrir le fichier COURBE_NB_FILE avec le nom s"et".data
  ex: s12.data
*/
char str[256];
sprintf(str,"s%d.data",et);
return CreCourbe(str);
}

/*==============================================================*/
void CloseCourbe(void)
/*
Pour fermer le fichier COURBE_NB_FILE
*/
{
if(COURBE_NB_FILE!=NULL) {
  fprintf(COURBE_NB_FILE,"-999999.\n");
  fclose(COURBE_NB_FILE);
}
COURBE_NB_FILE = NULL;
}

/*==============================================================*/
void FillCourbe(int et,int coul
               ,float t,float flx,float eflx,float flb,float eflb
               ,float v0,float v1,float v2,float v3,float v4)
/*
Pour remplir un fichier ASCII avec des courbes de lumieres:
 coul = couleur (1 ou 2)
 flx  = flux calibre
 eflx = erreur sur le flux calibre
 flb  = flux brut
 eflb = erreur sur le flux brut
 v0,v1,v2,v3,v4 = ce qu'on veut pour sequence temporelle
 - Code 1    , 2
        coul1, coul2
*/
{
if(COURBE_NB_FILE==NULL) {
  printf("FillCourbe_Erreur: fichier non ouvert!\n");
  return;
}
fprintf(COURBE_NB_FILE,"%d. %d. %f %f %f %f %f %f %f %f %f %f\n"
       ,coul,et,t,flx,eflx,flb,eflb,v0,v1,v2,v3,v4);
}

/*==============================================================*/
void FillBosse(int et,int coul
              ,float fbase,float tp1,float tp2,float ts1,float ts2)
/*
Pour remplir la caracteristique du flux de base et des bosses:
 coul  = couleur (1 ou 2)
 fbase = flux de base
 tp1   = temps de debut de la bosse principale
 tp2   = temps de fin   de la bosse principale
 ts1   = temps de debut de la bosse secondaire
 ts2   = temps de fin   de la bosse secondaire
 - Code 1000 , 2000
        coul1, coul2
*/
{
if(COURBE_NB_FILE==NULL) {
  printf("FillBosse_Erreur: fichier non ouvert!\n");
  return;
}
coul = 1000*coul;
fprintf(COURBE_NB_FILE,"%d. %d. %f %f %f %f %f\n"
       ,coul,et,fbase,tp1,tp2,ts1,ts2);
}

/*==============================================================*/
void FillPacZin(int et,int coul,int mc
               ,float fbase,float u0,float t0,float tau,float blend)
/*
Pour remplir la caracteristique d'un fct de paczinski:
 coul  = couleur (1 ou 2)
 mc    = <=0 fct fittee, >0 fct montecarlo
 fbase = flux de base
 u0    = parametre d'impact en Rayon d'einstein
 t0    = temps du maximum
 tau   = parametre de largeur
 blend = taux de blending (=1 si pas de blending!)
 - Code 1010 , 1011    , 2010 , 2011
        coul1, coul1+mc, coul2, coul2+mc
*/
{
if(COURBE_NB_FILE==NULL) {
  printf("FillPacZin_Erreur: fichier non ouvert!\n");
  return;
}
if(mc<=0) mc = 0; else mc = 1;
coul = coul*1000 + 10 + mc;
fprintf(COURBE_NB_FILE,"%d. %d. %f %f %f %f %f\n"
       ,coul,et,fbase,u0,t0,tau,blend);
}

/*==============================================================*/
void FillVarPer(int et,int coul,int mc
               ,int nharm,float fbase,float per,float t0
               ,float *pcs,float *psn)
/*
Pour remplir la caracteristique d'un fct periodique:
 coul  = couleur (1 ou 2)
 mc    = <=0 fct fittee, >0 fct montecarlo
 nharm = nombre d'harmoniques
 fbase = flux de base
 per   = periode
 t0    = temps zero
 pcs   = tableau des "nharm" multiplicateurs des cosinus
         Il y a donc 1 fondamental + nharm-1 harmoniques
 psn   = tableau des "nharm" multiplicateurs des sinus
 - Code 1020 , 1021    , 2020 , 2021
        coul1, coul1+mc, coul2, coul2+mc
 La fonction est:
 f(t) = fbase
      + Sum[pcs(i)*cos(2pi*i*(x-t0)/per) + psn(i)*sin(2pi*i*(x-t0)/per)]
                (i varie de 1,nharm)
*/
{
int i;
if(COURBE_NB_FILE==NULL) {
  printf("FillVarPer_Erreur: fichier non ouvert!\n");
  return;
}
if(mc<=0) mc = 0; else mc = 1;
coul = coul*1000 + 20 + mc;
fprintf(COURBE_NB_FILE,"%d. %d. %f %f %f\n"
       ,coul,et,fbase,per,t0);
for(i=0;i<nharm;i++)
  fprintf(COURBE_NB_FILE,"%d. %d. %f %f %f\n"
         ,coul,et,(float)(i+1),pcs[i],psn[i]);
}

