#ifndef LCPROC_H_SEEN
#define LCPROC_H_SEEN

#include "machdefs.h"  
#include "tvector.h"
#include "datatable.h"

#include "fsvst.h"

class LightCurveProc {
public:
  LightCurveProc(string outppf, int dtblks=128, int dtblkti=50);
  virtual ~LightCurveProc();

  void ProcessLC(int numet, int nmes, STARINFO *sti, TIMEINFO *tminf, MESUREU *mesu);
  void TimeInfo(int nmes, TIMEINFO *tminf);
  inline SOPHYA::DataTable& getDTS() { return dts; }
  
 protected:
  SOPHYA::DataTable dts;
  SOPHYA::DataTable dtti;
  vector<int> fgbad;  // Flag bad exposures (mesures)
  string _outname;
};

#endif
