/* Pour faire des tests de Xephem Librairie */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
/* include "P_.h" */
#include "astro.h"

#define R2D (180./PI)

int main(int narg,char** arg)
{
 int year=1989,month=7,day=21; /* UTC*/
 double hour=12.5;
 int npnum=8, pnum[8]={MERCURY,VENUS,MARS,JUPITER,SATURN,URANUS,NEPTUNE,PLUTO};
 int i;
 double mymjd,sunecl,sunecb,sundist,geodist,geoecl,geoecb,diamang,mag,msp,mdp;

 cal_mjd(month,day+hour/24.,year,&mymjd);
 printf("date %d/%d/%d %gh  -> mjd=%f\n",day,month,year,hour,mymjd);

 /* Soleil */
 sunpos(mymjd,&geoecl,&geodist,&geoecb);
 printf("Sun: geo ecl=%g ecb=%g dist=%g\n",geoecl*R2D,geoecb*R2D,geodist);

 /* Lune */
 moon(mymjd,&geoecl,&geoecb,&geodist,&msp,&mdp);
 printf("Moon: geo ecl=%g ecb=%g dist=%g\n",geoecl*R2D,geoecb*R2D,geodist);

 /* Planete */
 printf("--- Planets\n");
 for(i=0;i<npnum;i++) {
   plans(mymjd,pnum[i],&sunecl,&sunecb,&sundist,&geodist,&geoecl,&geoecb,&diamang,&mag);
   printf("pnum=%d: sun ecl=%g ecb=%g dist=%g,",pnum[i],sunecl*R2D,sunecb*R2D,sundist);
   printf(" geo ecl=%g ecb=%g dist=%g,",geoecl*R2D,geoecb*R2D,geodist);
   printf(" diamang=%g\"/1UA mag=%g\n",diamang,mag);
 }

 exit(0);
}
