#include "sopnamsp.h"
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>

#include <typeinfo>

#include <vector>
#include <string>

#include "piacmd.h"
#include "nobjmgr.h"
#include "pistdimgapp.h"


//  Exemple de module chargeable ds piapp 

//  Declaration de la fonction d'activation et de desactivation du module
extern "C" {
void exmodule_init();
void exmodule_end();
}


//  Une classe commande-executor, permettant d'enregistrer de 
//  nouvelles commandes a piapp
class exmoduleExecutor : public CmdExecutor {
public:
                exmoduleExecutor();
  virtual       ~exmoduleExecutor();
  // Execute s'occupe de l'execution effective des commandes
  virtual int   Execute(string& keyw, vector<string>& args, string& toks);
};

/* --Methode-- */
exmoduleExecutor::exmoduleExecutor()
{

PIACmd * mpiac;
NamedObjMgr omg;
mpiac = omg.GetImgApp()->CmdInterpreter();

// On enregistre deux nouvelles commandes 
string hgrp = "ExModuleCmd";
// commande excmd1
string kw = "excmd1";
string usage = "exmd1: Appel Print pour obj1 \n" ;
usage += "Usage: excmd1 obj1 ";
mpiac->RegisterCommand(kw, usage, this, hgrp);
// commande excmd2
kw = "excmd2";
usage = "exmd2: Appel Print pour obj1 et obj2 \n" ;
usage += "Usage: excmd2 obj1 obj2";
mpiac->RegisterCommand(kw, usage, this, hgrp);

}

/* --Methode-- */
exmoduleExecutor::~exmoduleExecutor()
{
}

/* --Methode-- */
int exmoduleExecutor::Execute(string& kw, vector<string>& tokens, string&)
{

NamedObjMgr omg;
if (kw == "excmd1") {
  if (tokens.size() < 1) {
    cout << "Usage: excmd1 obj1" << endl;
    return(0);
    }
  omg.PrintObj(tokens[0]);
  }
else if (kw == "excmd2") {
  if (tokens.size() < 2) {
    cout << "Usage: excmd2 obj1 obj2" << endl;
    return(0);
    }
  omg.PrintObj(tokens[0]);
  omg.PrintObj(tokens[1]);
  }

return(0);

}

static exmoduleExecutor * piaerex = NULL;
/* Nouvelle-Fonction */
void exmodule_init()
{
// Fonction d'initialisation du module
// Appele par le gestionnaire de modules de piapp (PIACmd::LoadModule())
if (piaerex) delete piaerex;
piaerex = new exmoduleExecutor;
}

/* Nouvelle-Fonction */
void exmodule_end()
{
// Desactivation du module
if (piaerex) delete piaerex;
piaerex = NULL;
}

