// This may look like C code, but it is really -*- C++ -*-
// Classe  GNUPlotContour   : interface avec le code de gnuplot pour tracer les contours
// Classe  PIContourDrawer  : trace des contours dans PI 
// (c) DAPNIA (CEA)                 LAL (IN2P3/CNRS)
//                           R. Ansari O.Perdereau  11/2001
//=========================================================//

#ifndef PIGNCONT_H_SEEN 
#define PIGNCONT_H_SEEN 
#include "pistdimgapp.h"
#include "piscdrawwdg.h"

#include "ntuple.h"
extern "C" { 
#include "gp_contour.h"
#include "gp_alloc.h"
  //#include "gpc_set.h"
}

class GNUPlotContour{
public:
  GNUPlotContour(P2DArrayAdapter*,int *nz,double *z0,double *dz);
  GNUPlotContour(NTupleInterface *nt,int *nz,double *z0,double *dz);
  GNUPlotContour(struct iso_curve *);
  ~GNUPlotContour();
  void CalcContour();
  double Level(int i){return My_Levels[i];};
  const double *Levels(){return My_Levels;};
  void SetMyLevels(double *ptr,int k);
  void SetMyLevels(vector <double> vec);
  int NLevels(){return Contour_Levels;};
  void SetNLevel(int n){Contour_Levels=n;};
  int NContours(){return _npolys;};
  void SetCntLevelKind(t_contour_levels_kind kind){Contour_Levels_kind = kind;};
  t_contour_levels_kind GetCntLevelKind() const {return Contour_Levels_kind ;};
  void SetCntKind(t_contour_kind kind){Contour_kind = kind;};
  t_contour_kind GetCntKind() const {return Contour_kind ;};


  NTuple * & MyIso(){return  _myiso;};

  double Xmin(){return _xmin;};
  double Xmax(){return _xmax;};
  double Ymin(){return _ymin;};
  double Ymax(){return _ymax;};
  double Zmin(){return _zmin;};
  double Zmax(){return _zmax;};

private: 

protected: 
  NTuple * _myiso;
  int _nx,_ny;
  struct iso_curve *iso1 ;
  bool _Invx,_Invy,_Exy;
  double _Dxp, _Dyp;
  struct gnuplot_contours *_contours;
  int Contour_Levels;
  
  double *My_Levels; 
  
  double _xmin,_xmax,_ymin,_ymax,_zmin,_zmax;
  int _npolys;
  t_contour_levels_kind Contour_Levels_kind;
  t_contour_kind Contour_kind;
  
  
};

class PIContourDrawer : public PIDrawer, public GNUPlotContour{
public:
                    PIContourDrawer(P2DArrayAdapter* arr,bool autodel ,int *nz=NULL,double *z0=NULL,double *dz=NULL);
                    PIContourDrawer(NTupleInterface* nti,bool autodel ,int *nz=NULL,double *z0=NULL,double *dz=NULL);
  virtual           ~PIContourDrawer();
  virtual void      Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void      UpdateLimits();
  virtual bool      IsLineOn() const;
  virtual bool      IsMarkOn() const;  
  virtual bool      IsLabelOn() const;
  virtual void      SetLineOn(bool b=true);
  virtual void      SetMarkOn(bool b=true);
  virtual void      SetLabelOn(bool b=true);

  //Init  attributs graphiques 

  void InitAtts();  
  
  
//  Methode permettant l'affichage d'une fenetre de controle specialisee 
  virtual void      ShowControlWindow(PIBaseWdgGen* wdg);
  //  Desactivation de la fenetre de controle specialisee
  virtual void DeactivateControlWindow(PIBaseWdgGen* wdg);
//   Methode permettant de decoder des options a partir de chaines
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int        OptionToString(vector<string> & opt) const;
//   Texte d'aide des options disponibles
  virtual void       GetOptionsHelpInfo(string& info);


protected:
  bool _autodel;
  int _nz;
  P2DArrayAdapter* _arr;
  NTupleInterface* _nti;
  bool mLineOn,mMarkOn,mLabelOn;
  

  

};


//

#endif
