#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
 
#include "fsvcache.h"

#if ( IS_BIG_ENDIAN == 0 ) 
#define SWAPDEFAUT 1
#else
#define SWAPDEFAUT 0
#endif

int main(int narg, char *arg[])
{
SUIVIFIP *sfip;
ENTETESUIVI head;
FILE *fip;
char *flnm;
int_4 newnmes,ntronq,fgr;
char *buff;
int_4 nmes, nstar;
int rc;
int jt, szbuff;
int fgtronq;
int fgswapdef;
int_4 fgcorrnmes;
int_4 newfgcorr;

if (narg < 2)
  {
  puts(" CheckFSV_Erreur : Arguments incorrects ! (-h pour usage)");
  exit(1);
  }
if (strcmp(arg[1],"-h") == 0)
  {
  puts("Usage: CheckFSV  NomSuivi");
  puts("  ou   CheckFSV [-restore] NomSuivi");
  puts("  ou   CheckFSV [-tronq nmes] NomSuivi");
  puts("  ou   CheckFSV [-swapdefaut] NomSuivi");
  puts("  ou   CheckFSV [-fgcorrnmes fgcorr,nmes] NomSuivi");  
  puts("Rc=0 -> Fichier OK, RC > 0 = Nb de mesure OK");
  puts("-restore : Tronquer le fichier au nombre de mesure OK"); 
  puts("-tronq nmes : Tronquer le fichier au nombre de mesure nmes"); 
  puts("-swapdef : Changer la valeur de Flg Swap a SWAPDEFAUT");
  puts("-fgcorrnmes fgcorr,nmes : Modifie les valeurs de FgCorrupt et NbMes ds l'entete"); 
  exit(2);
  }
 
fgswapdef = fgcorrnmes = 0;
newfgcorr = newnmes = 0;
ntronq = -1;

if (strcmp(arg[1],"-swapdefaut") == 0) {
  if (narg < 3) { 
    puts(" CheckFSV_Erreur : Arguments incorrects ! (-h pour usage)");
    exit(2); 
  }
  flnm = arg[2];  fgswapdef = 1;
}
else if (strcmp(arg[1],"-fgcorrnmes") == 0) {
  if (narg < 4) { 
    puts(" CheckFSV_Erreur : Arguments incorrects ! (-h pour usage)");
    exit(2); 
   }
  sscanf(arg[2],"%d,%d", &newfgcorr, &newnmes);
  flnm = arg[2];   fgcorrnmes = 1;
}

if (fgcorrnmes || fgswapdef) {
  if ( (fip = fopen(flnm,"rb+")) == NULL )  
    {
    printf("CheckFSV/Erreur: Pb d'ouverture de %s \n",flnm);
    exit(5);
    }  
  fseek(fip, (long)0, SEEK_SET);
  fread(&head,sizeof(ENTETESUIVI),1,fip);
  if (fgswapdef) {
    printf("CheckFSV/Info: Modification Flag Swap entete suivi %s \n", flnm);
    printf("CheckFSV/Info: FgSwap: Lu= %x ", head.Swap);
    if (SWAPDEFAUT)  head.Swap = 0xFFFF;
    else head.Swap = 0;
    printf(" Ecrit= %x \n", head.Swap);
  }
  else {
    printf("CheckFSV/Info: Modification FgCorrupt NbMes -  suivi %s \n", flnm);
    printf("CheckFSV/Info: Lu - FgCorrupt=%d NMes=%d", head.FgCorrupt, head.NbMesTot);
    head.FgCorrupt = newfgcorr; 
    head.NbMesTot = newnmes;
  }
  fseek(fip, (long)0, SEEK_SET);
  fwrite(&head,sizeof(ENTETESUIVI),1,fip);
  fclose(fip);
  exit(0);
  }

fgtronq = 0;
if (strcmp(arg[1],"-restore") == 0)
  {
  if (narg < 3) { 
    puts(" CheckFSV_Erreur : Arguments incorrects ! (-h pour usage)");
    exit(2); }
  flnm = arg[2];   fgr = SUOF_RW;   fgtronq = 1;
  }
else if (strcmp(arg[1],"-tronq") == 0)
  {
  if (narg < 4) { 
    puts(" CheckFSV_Erreur : Arguments incorrects ! (-h pour usage)");
    exit(2); }
  flnm = arg[3];  ntronq = atoi(arg[2]);  fgr = SUOF_RW;  fgtronq = 1;
  }
else { fgr = SUOF_RO_MEM;  flnm = arg[1]; }

printf("CheckFSV/Info: Verification fichier %s \n", flnm);

SuiviSetPrtLevel(5);
if ( (sfip = SuiviOpen(flnm, fgr)) == NULL)
  { printf(" CheckFSV_Erreur: Pb d'ouverture de %s \n",flnm);
  exit(99); }

newnmes = rc = 0;
if ((sfip->Head.NbMesTot != sfip->Head.FgCorrupt) || (sfip->Head.NbMesTot < 0)) {
  printf("\nCheckFSV/warning: Fichier %s corrompu, NbMes=%d FgCorrupt=%d \n",
         flnm,sfip->Head.NbMesTot,sfip->Head.FgCorrupt);
  rc = newnmes = (sfip->Head.FgCorrupt < 0) ? -sfip->Head.FgCorrupt : sfip->Head.FgCorrupt;
  if (!fgtronq)  goto Fin;  // Si fichier corrompu et pas de tronq prevu 
  if ( (ntronq >= 0) && (ntronq <= newnmes) )  newnmes = ntronq;
  if (newnmes < 0) {
    printf("\nCheckFSV/Bug: NewNMes= %d (<0 ->Rc=98) \n", newnmes); 
    rc = 98;  goto Fin;
  }
}
if ( (newnmes < sfip->Head.NbMesTot) && fgtronq ) {
  printf("\nCheckFSV/Info: Fichier tronque a NbMes= %d \n", newnmes); 
  sfip->Head.FgCorrupt = sfip->Head.NbMesTot = newnmes;
}

/* On verifie qu'on sait lire toutes les TimeInfos et les mesures pour l'etoile NbStar */
szbuff = (sfip->Head.RecSize[3] >  sfip->Head.RecSize[4]) ? 
          sfip->Head.RecSize[3]*2 : sfip->Head.RecSize[4]*2;
if ((buff=(char *)malloc(szbuff)) == NULL)  { 
  printf("CheckFSV/erreur: Probleme malloc( buff) ! \n");
  rc = 99;  goto Fin; 
}
nmes = SuiviGetNbMesures(sfip);
nstar = SuiviGetNbStars(sfip);
for(jt=1; jt<=nmes; jt++) {
  rc = SuiviReadTimeInfo(sfip,jt,jt,buff);
  if (rc != 0)   { 
    printf("\nCheckFSV/warning: Fichier %s corrompu, Rc(RdTimeInfo(%d))=%d (FgCorrupt=%d) \n",
           flnm, jt, rc, sfip->Head.FgCorrupt);
    rc = jt;
    break;
  } 
  if (nstar < 1)  continue;  
  rc = SuiviReadMesures(sfip, nstar, jt, jt, buff);  
  if (rc != 0)   { 
    printf("\nCheckFSV/warning: Fichier %s corrompu, Rc(RdMesure(%d, %d))=%d (FgCorrupt=%d) \n",
           flnm,nstar,jt,rc,sfip->Head.FgCorrupt);
    rc = jt;
    break;
  }
} 


Fin :
SuiviSetPrtLevel(0);
SuiviClose(sfip);
if (rc == 0) printf("CheckFSV/Info: Suivi %s OK RC= %d \n", flnm, rc);
else printf("CheckFSV/Erreur: ReturnCode = %d \n", rc);
if (rc > 99) rc = 99;
exit(rc);
}
