// Classe d'initialisation du module Outils++ 
#include <unistd.h>

#include "sopnamsp.h"
#include "skyinit.h"
#include "ppersist.h"
#include "objfio.h"
#include "specrespvector.h"
#include "gaussfilt.h"

/*! \class SOPHYA::SkyTInitiator
   \ingroup SkyT
*/
int SkyTInitiator::FgInit = 0;

// Module version number 
#define MOD_VERS  0.7 

SkyTInitiator::SkyTInitiator()
  : NToolsInitiator()
{
  SkyTInitiator::FgInit++;
  if (SkyTInitiator::FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules SkyT
  
  PPRegister(ObjFileIO<SpecRespVec>);
  DObjRegister(ObjFileIO<SpecRespVec>, SpecRespVec);
  PPRegister(ObjFileIO<GaussianFilter>);
  DObjRegister(ObjFileIO<GaussianFilter>, GaussianFilter);

  SophyaInitiator::RegisterModule("SkyT", MOD_VERS);  // Module name and version number registration
}

SkyTInitiator::~SkyTInitiator()
{
  SkyTInitiator::FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static SkyTInitiator s_skytinit_;

