#ifndef PIAPPLX_H_SEEN
#define PIAPPLX_H_SEEN

#include "piapplgen.h"
#include "piwdgx.h"
#include "picontainerx.h"

class PIApplicationX : public PIApplicationGen {
public:
  		            PIApplicationX(int sx=200, int sy=30, int narg=0, char *arg[]=NULL);

  virtual	            ~PIApplicationX();
	
  virtual void              Run();
  virtual void              Stop() { mStop = false; }

  virtual void              SetReady();
  virtual void              SetBusy(); 
  virtual void              SetBlocked();

  virtual void              PrefCompSize(int& szx, int& szy);
  virtual void              ScreenSize(int& szx, int& szy);
  virtual void              ScreenSizeMM(int& szx, int& szy);
  virtual void              ScreenResolution(int& resolx, int& resoly);

  virtual void              RedirectOutStream(PIConsole* cons, unsigned char va= PIVA_Def);
  virtual void              RedirectErrStream(PIConsole* cons, unsigned char va= PIVA_Red);
  virtual void              RedirectOutStream(PIConsole* cons, string const & flnm, bool fgcpos=false, 
					      unsigned char va= PIVA_Def);
  virtual void              RedirectErrStream(PIConsole* cons, string const & flnm, bool fgcpos=false, 
					      unsigned char va= PIVA_Def);

  PIContainer*              MBCont() { return intcont; }
protected:
  PIWdg * topwdg;
  PIContainer * intcont;
  bool mStop;
};

typedef PIApplicationX PIApplication;

//  Pour recuperer un objet PIApplication 
PIApplication* PIApplicationGetApp();
#endif
