// This may look like C code, but it is really -*- C++ -*-
// Classe interpreteur de commande pour piapp 
// Reza      Aout 97 , Juillet,Aout 98
// LAL-IN2P3/CNRS

#ifndef PIACMD_H_SEEN
#define PIACMD_H_SEEN

#include "machdefs.h"
#include "commander.h"
#include <string>
#include <vector>
#include <queue>
#include "zthread.h"

#include "dlftypes.h"

// Forward declaration of some classes ...
class NamedObjMgr;
class PIStdImgApp;

class PIAHelpWind;   // Fenetre d'aide en ligne 
class CxxExecWind;   // Fenetre pour CxxExecutor
class CxxOptionWind; // Option de CxxExecutor

// ---------------------------------------------------------------------
// Classe Interpreteur de commande, gestionnaire de module chargeable,
// et de fonctions dynamiquement linke pour PIStdImgApp
// Permet de gerer plusieurs Interpreter differents 
// ---------------------------------------------------------------------


class PIACmd : public Commander, public ZThread  {
public:
  //  static PIACmd*	GetInterpreter();

			PIACmd(PIStdImgApp* app);
  virtual		~PIACmd();

  // Thread execution  <ZThread>
  virtual void          run();
  void                  AddInputLine(string const & line);
  void                  StopThread();
  inline  bool          isRunning(int& ninp) 
    { ninp = inputlines.size(); return fg_threxe; }
  // ---- FIN ---- Thread execution  <ZThread>

  void                   ShowHelpWindow();
  void                   ShowCxxOptionWindow();
  void                   ShowCxxExecWindow();

    //  inline  CmdInterpreter* CurrentInterpreter() { return(curcmdi); }

  inline  CmdExecutor*   BaseExecutor()  { return(basexec); }
  inline  CmdExecutor*   ContExecutor()  { return(cntexec); } //_OP_
  inline  PIStdImgApp*   GetImgApp() { return(mImgApp); }

//   Pour utilisation par PIAHelpWind uniquement 
  virtual void		UpdateHelpList(PIAHelpWind* hw, int gid);

// Acces aux objets transforme en string 
  virtual bool    GetVarApp(string const & vn, string & vv);

protected:
  virtual int   ExecuteCommandLine(string & kw, vector<string> & tokens, 
				   string & toks);

  virtual bool	CheckHelpGrp(string& grp, int& gid, string& desc);
  virtual void	InitializeHelpWindowMenu();

  virtual void  SetCurrentPrompt(const char* pr);
  virtual void	ShowMessage(const char * msg, int att);

  NamedObjMgr* mObjMgr;
  PIStdImgApp* mImgApp;

  CmdExecutor* basexec;  // base command executor
  CmdExecutor* graphexec; // graphic command executor
  CmdExecutor* fitexec;  // Fit command executor
  CmdExecutor* pawexec;  // paw-like command executor
  CmdExecutor* cxxexec;  // on-line c++ compile/execution command executor

  CmdExecutor *cntexec; // contour executor _OP_
  CmdExecutor *flwexec; // flow chart executor _OP_
 
// Fenetre d'aide interactive 
  PIAHelpWind* helpwin;
  bool helpwin_initdone;
// Fenetres d'execution interactive de C++ , options correspondantes
  CxxExecWind* cxxexwin;
  CxxOptionWind* cxxoptwin;

// Queue des entrees et controle de thread
  queue<string> inputlines;
  bool fg_thrstop;
  ZMutex mutx_inps;
  bool fg_threxe;

};


// 
// ---------------------------------------------------------------------
// Classe d'execution d'operations simples, comme affichage (display)
// print , del ... issues en particulier de la boucle d'evts 
// (PIStdImgApp, ObjMgrWind , ...)
// ---------------------------------------------------------------------

class SOpExObj : public ZThread  {
public:
			SOpExObj(PIStdImgApp* app);
  virtual		~SOpExObj();

  // Thread execution  <ZThread>
  virtual void          run();
  void                  AddOpe(string const & line);
  void                  StopThread();

protected:
  PIStdImgApp* mImgApp;
  queue<string> inputlines;
  ZMutex mutx_inps;
  bool fg_thrstop;
  bool fg_threxe;
};




#endif
