#ifndef FILECACHE_H_SEEN
#define  FILECACHE_H_SEEN


#include <stdio.h>
#include "machdefs.h"
 
#ifdef __cplusplus
extern "C" {
#endif


#define  DEF_PGSIZE  4096
#define  DEF_NPAGE   50
#define  MIN_PGSIZE  512
#define  MIN_NPAGE   10
 
  
typedef struct  dskpage
  {
  int wrfg;
  char *page;
  int_4 pgno;
  struct dskpage *next, *prev;
  }  DSKPAGE;
 
 
typedef struct  filecache
  {
  FILE *fip;
  int fidesc;
  int memode, rwfg;
  long int fpos;
  long int fsz;
  int_4 npage, pgsize;
  DSKPAGE  *pages;  /* pointeur sur la zone memoire de toutes les pages */
  DSKPAGE  *first, *last;
  int_4 nread, nwrite;
  long int totrd, totwr;
  } FILECACHE ;
 
 
FILECACHE  *zfopen(char *flnm, char *mode, int NPg, int PgSiz);
int zfseek( FILECACHE *fcp, long int offset, int fg);
size_t zfread( void *buff, size_t size, size_t nitems, FILECACHE *fcp);
size_t zfwrite( void *buff, size_t size, size_t nitems, FILECACHE *fcp);
void zfclose( FILECACHE *fcp );
void zfSetPrtLevel(int lev);

#ifdef __cplusplus
}
#endif

#endif

