// Classe d'initialisation du module HiStats 
//                        (Histogram and Statistics)

#include "sopnamsp.h"
#include "machdefs.h"
#include "histinit.h"

#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "histerr.h"
#include "hist2err.h"
#include "ntuple.h"
#include "datatable.h"
#include "swppfdtable.h"

/*!
   \defgroup HiStats HiStats module
   This module contains histograms (1D, 2D) and 
   classes for management of data sets as tables (NTuple, DataTable ...)
*/
 
int HiStatsInitiator::FgInit = 0;

// Module version number - 2.0 , Jul 2006
// Module version number - 2.1 , Jan 2007  (Nouvelle version de HistoErr + 2DErr)
#define MOD_VERS   2.1 

/*!
  \class SOPHYA::HiStatsInitiator
  \ingroup HiStats
  This class performs the initialisation for HiStats module.
  More specifically, it registers PPF handlers for the following classes :
  - Histo
  - HProf
  - Histo2D
  - HistoErr
  - Histo2DErr
  - NTuple
  - DataTable
  - SwPPFDataTable

  If the system linker/loader handles correctly static object initialisation, there
  is no action required when writing programs. If not, an instance of the class must
  be present before any other operation on the libray classes. 
*/

HiStatsInitiator::HiStatsInitiator()
  : NToolsInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules HiStats
  
  PPRegister(ObjFileIO<Histo>);
  DObjRegister(ObjFileIO<Histo>, Histo);
  PPRegister(ObjFileIO<Histo2D>);
  DObjRegister(ObjFileIO<Histo2D>, Histo2D);
  PPRegister(ObjFileIO<HProf>);
  DObjRegister(ObjFileIO<HProf>, HProf);

  PPRegister(ObjFileIO<HistoErr>);
  DObjRegister(ObjFileIO<HistoErr>, HistoErr);
  PPRegister(ObjFileIO<Histo2DErr>);
  DObjRegister(ObjFileIO<Histo2DErr>, Histo2DErr);

  PPRegister(ObjFileIO<NTuple>);
  DObjRegister(ObjFileIO<NTuple>, NTuple);

  PPRegister(ObjFileIO<BaseDataTable>);
  DObjRegister(ObjFileIO<BaseDataTable>, DataTable);
  DObjRegister(ObjFileIO<BaseDataTable>, SwPPFDataTable);

  SophyaInitiator::RegisterModule("HiStats", MOD_VERS);  // Module name and version number registration

}

HiStatsInitiator::~HiStatsInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static HiStatsInitiator histatsinit;

