// This may look like C code, but it is really -*- C++ -*-
//      template array class for numerical types
//                     R. Ansari, C.Magneville   03/2000
//  Ajout gestionnaire PPF pour TriangularMatrix<T>   02/2009

#ifndef FIOSpSqMtx_SEEN
#define FIOSpSqMtx_SEEN

#include "machdefs.h"
#include <iostream>
#include "spesqmtx.h"
#include "trngmtx.h"
#include "diagmtx.h"
#include "symmtx.h"
#include "ppersist.h"

namespace SOPHYA {

//------------------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////
// Gestionnaire PPF de SpecialSquareMatrix<T>

/*! 
  \brief Manager class the PPF I/O (SOPHYA persistence) of TriangularMatrix<T> objects.
 */

template <class T>
class FIO_SpecialSquareMatrix : public  PPersist  {
public:
  FIO_SpecialSquareMatrix();
  FIO_SpecialSquareMatrix(string const & filename); 
  FIO_SpecialSquareMatrix(const SpecialSquareMatrix<T> & obj);
  FIO_SpecialSquareMatrix(SpecialSquareMatrix<T> * obj);
  virtual ~FIO_SpecialSquareMatrix();
  virtual AnyDataObj* DataObj();
  virtual void        SetDataObj(AnyDataObj & o);
  inline operator SpecialSquareMatrix<T>() { return(*dobj); }
protected :
  virtual void ReadSelf(PInPersist&);           
  virtual void WriteSelf(POutPersist&) const;  
  SpecialSquareMatrix<T> * dobj; //!< Pointer to the connected SpecialSquareMatrix
  bool ownobj; //!< true if the connected object belong to the class
};

/*! \ingroup TArray \fn operator<<(POutPersist&,SpecialSquareMatrix<T>&)
  \brief Write SpecialSquareMatrix \b obj into POutPersist stream \b os */
template <class T>
inline POutPersist& operator << (POutPersist& os, SpecialSquareMatrix<T> & obj)
{ FIO_SpecialSquareMatrix<T> fio(&obj);  fio.Write(os);  return(os); }

/*! \ingroup TArray \fn operator>>(PInPersist&,SpecialSquareMatrix<T>&)
  \brief Read SpecialSquareMatrix \b obj from PInPersist stream \b os */
template <class T>
inline PInPersist& operator >> (PInPersist& is, SpecialSquareMatrix<T> & obj)
{ FIO_SpecialSquareMatrix<T> fio(&obj); is.SkipToNextObject(); fio.Read(is); return(is); }


} // Fin du namespace

#endif
