// Module PI : Peida Interactive     PIFileChooser
// Selecteur de fichier                    96-97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "sopnamsp.h"
#include "pifilechogen.h"


/************* PIFileChooserGen ************/

//++
// Class	PIFileChooser
// Lib		PI
// include	pifilechogen.h
//
//	Composant graphique de type slecteur de fichier, permettant de choisir 
//	un nom de fichier et de naviguer dans les rpertoires.
//	"PIFileChooserGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIFileChooser" dclare dans le fichier
//	entte "PIFILECHO_H". Le message associ  l'objet est envoy complet 
//	avec "PIMsg_OK" si un nom de fichier a t choisi. la variable "data"
//	est alors un pointeur sur une chane de caractres ("char *"), 
//	contenant le nom complet du fichier. Si aucun fichier n'a t 
//	slectionn, le message de l'objet est complet avec "PIMsg_Cancel" et 
//	le "data" contient le pointeur "NULL".
//--
//++
// Links	Parents
// PIWdg
//--
//++
// Titre	Constructeur et mthodes
//--
//++
// PIFileChooser(PIMsgHandler* par, const char* nom, PIMessage msg)
//	Cration d'un objet slecteur de fichier, avec le message "msg".
// void  Show()
//	Affiche la fentre de slection des fichiers
// void  AcceptNewFile(bool acc)
//	Active ("acc=true") ou dsactive la possibilit de spcifier
//	un nouveau fichier.
// void  SetPath(string const&)
//	Dfinit le chemin d'accs (rpertoire) choisi par dfaut
// void  SetFileName(string const&) 
//	Nom de fichier slectionn par dfaut
// string  GetPath()
//	Retourne le chemin d'accs. NON IMPLEMENTE EN X/MOTIF (06/98)
// string  GetFileName()
//	Retourne le nom complet du fichier slectionn. 
//--


PIFileChooserGen::PIFileChooserGen(PIMsgHandler* par, const char* nom, PIMessage msg)
: PIWdg(NULL, nom)
{
SetMsg(msg);
SetMsgParent(par);
}

PIFileChooserGen::~PIFileChooserGen()
{}

void PIFileChooserGen::Show()
{
return;
}


void PIFileChooserGen::AcceptNewFile(bool)
{
return;
}


