/* Fonctions interface XWindow pour affichage d'images */

#ifndef PIPIXMAP_H_SEEN
#define PIPIXMAP_H_SEEN

#include "pisysdep.h"

#include PIBWDG_H
#include PICMAP_H

#include "pipixutils.h"

#include <list>


class PIPixmapGen : public PIBaseWdg
{
public:
  enum {ClassId = 5100};

                PIPixmapGen(PIContainerGen *par, const char *nom,
                         int sx=10, int sy=10, int px=0, int py=0);
  virtual       ~PIPixmapGen();

  virtual long  kind() {return ClassId; }

  virtual void  SetPixmap(PIPixColIdx *pixidx, bool refr=true, int ox=0, int oy=0);
  virtual void  SetRGBArray(PIPixRGBArray *rgba, CMapId cmapid=CMAP_RGB512, 
                            bool refr=true, int ox=0, int oy=0);

  virtual void  SetColMap(PIColorMap* cmp, bool refr=true);
  virtual void  SetColMapId(CMapId cmapid, bool revidx, bool refr);
  inline  void  SetColMapId(CMapId cmapid, bool refr=true)
                { SetColMapId(cmapid, false, refr); }

  inline PIColorMap* GetColMap() { return cmap; }
  inline CMapId GetColMapId() { return ((CMapId)cmap->Type()); }; 
  inline int    NbCol() { return(cmap->NCol()); };

  virtual void  But1Press(int x, int y);
  inline  int   XPPos() { return mPpos[0]; }
  inline  int   YPPos() { return mPpos[1]; }

protected:
  PIPixColIdx *pixmap;   // Pointeur d'objet PIPixCoIdx, tableau d'index de couleurs, peut etre NULL
  bool fgownpmap;  // si true -> possede le pixmap et doit le deleter si besoin
  int ofx, ofy;       // Offset d'affichage 
  PIColorMap* cmap;

  int mPpos[2];
};  
  



#endif   /* PIPIXMAP_H_SEEN */


