#include "sopnamsp.h"
#include "piupdattachment.h"
//const MessageT	msg_MouseUp			= 819;

PIUpdAttachment* PIUpdAttachment::lastCursPane = NULL;
bool PIUpdAttachment::hit = false;
int PIUpdAttachment::down = 0;

PIUpdAttachment::PIUpdAttachment(PIBaseWdgMac* wdg)
: LAttachment(), myWdg(wdg)
{
  myGraphic = (PIGraphicMac*) wdg->WindowGraphic();
}

PIUpdAttachment::~PIUpdAttachment()
{
  if (lastCursPane == this) lastCursPane = NULL;
  delete myGraphic;
}

void PIUpdAttachment::ExecuteSelf(MessageT msg, void* data)
{
  if (myWdg)
    switch(msg) {
      case msg_DrawOrPrint:
        myWdg->Draw(myGraphic,0,0,999999,999999);
 		break;
      case msg_Resize:
        myWdg->Resize();
 		break;
      case msg_Move:
//        myWdg->Move();
        break;
//      case cmd_Close: {
//        delete myWdg;
//        break;
//      }
      case msg_Click: {
        SMouseDownEvent* evt = (SMouseDownEvent*) data;
        EventModifiers mod = evt->macEvent.modifiers;
        if ((mod & cmdKey) && (mod & optionKey))
          { myWdg->But3Press(evt->whereLocal.h,evt->whereLocal.v); down = 3;}
        else if (mod & cmdKey)
          { myWdg->But2Press(evt->whereLocal.h,evt->whereLocal.v); down = 2;}
        else
          { myWdg->But1Press(evt->whereLocal.h,evt->whereLocal.v); down = 1;}
 		break;
 		}
 	  case msg_KeyPress: {
 	    EventRecord* evt = (EventRecord*) data;
 	    PIKeyModifier kmod = PIKM_Blank;
 	    if (evt->modifiers & shiftKey)
 	      kmod = (PIKeyModifier) (kmod | PIKM_Shift);
 	      //kmod |= PIKM_Shift;  // Ca devrait passer !!!
 	    if (evt->modifiers & optionKey)
 	      kmod = (PIKeyModifier) (kmod | PIKM_Alt);
 	    if (evt->modifiers & controlKey)
 	      kmod = (PIKeyModifier) (kmod | PIKM_Cntl);
 	    myWdg->Keyboard(evt->message & charCodeMask, kmod);
 	    break;
 	    }
 	  case msg_AdjustCursor: {
 	    EventRecord* evt = (EventRecord*) data;
 	    if (lastCursPane != this) {
 	      if (lastCursPane)
 	        lastCursPane->myWdg->Leave();
 	      myWdg->Enter();
 	      lastCursPane = this;
 	    }
 	    hit = true;
 	    SetExecuteHost(!myWdg->AdjustCursor());
 	    // Est-ce un move, i.e. le bouton est-il toujours appuye depuis le dernier MouseDown ?
 	    if (::StillDown() && down) {
 	      Point pt = evt->where;
 	      myWdg->mPane->GlobalToPortPoint(pt);
 	      myWdg->mPane->PortToLocalPoint(pt);
 	      if (lastPt.h != pt.h || lastPt.v != pt.v) {
 	        lastPt = pt;
            EventModifiers mod = evt->modifiers;
            if ((mod & cmdKey) && (mod & optionKey))
              myWdg->Ptr3Move(pt.h,pt.v);
            else if (mod & cmdKey)
              myWdg->Ptr2Move(pt.h,pt.v);
            else
              myWdg->Ptr1Move(pt.h,pt.v);
          }
 	    } else if (down) {  // A changer le jour ou les attachements recoivent les mouseup.
 	      Point pt = evt->where;
 	      myWdg->mPane->GlobalToPortPoint(pt);
 	      myWdg->mPane->PortToLocalPoint(pt);
          EventModifiers mod = evt->modifiers;
          //if ((mod & cmdKey) && (mod & optionKey))
          if (down == 3)
            myWdg->But3Release(pt.h,pt.v);
          //else if (mod & cmdKey)
          else if (down == 2)
            myWdg->But2Release(pt.h,pt.v);
          else
            myWdg->But1Release(pt.h,pt.v);
 	      down = 0;
        }
 	    break;
 	    }
    }
}