#include "vfs.h"
#include "pexceptions.h"
#include "fiondblock.h"  // To use NDataBlock PPF services

/* Vfs class constructor */
Vfs::Vfs(int sz) 
    : mFVal(sz)
{
  for(int k=0; k<sz; k++)
    mSVal.push_back("");
}

void Vfs::Set(int k, r_4 fv, string const  sv)
{
  if ((k < 0) || (k>= (int)mFVal.Size())) 
    throw SOPHYA::RangeCheckError("Vfs::Set() Out of range index!");
  mFVal(k) = fv;
  mSVal[k] = sv;  
}

r_4 Vfs::GetF(int k)
{
  if ((k < 0) || (k>= (int)mFVal.Size())) 
    throw SOPHYA::RangeCheckError("Vfs::GetF() Out of range index!");
  return mFVal(k);
}

string Vfs::GetS(int k)
{
  if ((k < 0) || (k>= (int)mFVal.Size())) 
    throw SOPHYA::RangeCheckError("Vfs::GetS() Out of range index!");
  return mSVal[k];
}

void Vfs::Print(ostream& os) const
{
  os << "Vfs::Print() - Size= " << mFVal.Size() << endl;
  for(int k=0; k<(int)mFVal.Size(); k++)
    os << "K=" << k << " FVal= " << mFVal(k) << " SVal=" << mSVal[k] << endl;
  os << endl;  
}

//-----------------------------------------------------------------------
//  The PPF handler : ObjFileIO<T> is in namespace SOPHYA , 
//  We declare ObjFileIO<Vfs> in the SOPHYA namespace ...
//  Only, the WriteSelf() and ReadSelf() methods have to be provided
//-----------------------------------------------------------------------

namespace SOPHYA {

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
void ObjFileIO<Vfs>::WriteSelf(POutPersist& s) const
{
//  On ecrit 2 uint_4 .... 
//  0: Numero de version,  2 : reserve
  uint_4 itab[2];
  itab[0] = 1;  // Numero de version a 1
  itab[1] = 0;  // Reserved for future use
  s.Put(itab, 2); 
  s << dobj->mFVal;  // We write the float data block 
// We write now the string vector , as a series of strings 
  for(int k=0; k<(int)dobj->mFVal.Size(); k++)
      s.PutStr(dobj->mSVal[k]);
}

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
void ObjFileIO<Vfs>::ReadSelf(PInPersist& s)
{
// We read in the same order as the write
    // First the two integer containing the version numer
  uint_4 itab[2];
  s.Get(itab, 2); 
// next, we read in the float data vector 
  s >> dobj->mFVal;  
// We resest the  vector<string> dobj->mSVal
  dobj->mSVal.clear();
// We read in the mFVal.Size() and keep them in dobj->mSVal
  string buff; 
  for(int k=0; k<(int)dobj->mFVal.Size(); k++) {
    s.GetStr(buff);  
    dobj->mSVal.push_back(buff);
  }  
}

// We force the instanciation of the template class ObjFileIO<Vfs>
#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template ObjFileIO<Vfs>
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class ObjFileIO<Vfs>;
#endif

} // End of namespace SOPHYA 

