// Utilisation des flots d'entree-sortie C++
#include <iostream>

#include <math.h>
#include "sopnamsp.h"
#include "nbmath.h"
// Utilisation de la classe Scan
#include "sambainit.h"
#include "scan.h"
#include "ppersist.h"
int main()  
{
  // ----- ATTENTION -------
  // Initialisation de Sophya
  // A faire au debut de main()
  SophyaInit();

  int nbpix;
  float teta,phi;
  float Ouv,d_tet,Omega[3],fech,T,T0,phi0;

  // provisoire : recupere (teta,phi) position du satellite (en degres)
  teta= 0.;
  phi = 0.;
  
  // Ouverture
  Ouv= 90.*(float)Pi/180.;
  // Direction de l'axe de rotation du satellite
  Omega[0]= teta*(float)Pi/180.;
  Omega[1]= phi*(float)Pi/180.;
  // Vitesse de rotation
  Omega[2]= (float)Pi;
  // Frequence
  fech= 30.;
  // Temps max
  T= 2.;
  // Temps initial
  T0= 0.;
  // Offset
  phi0= 0.;
  int npas=15;
  d_tet= (float)Pi*0.5/npas;
  Scan equ(Ouv,Omega,fech,T,T0,phi0);
  nbpix= equ.NbPoints();
  cout << " nb pixels " << nbpix << endl;
  for( int j=0; j<nbpix; j++ ) {
    equ(j)=  100.*(j+1)/npas;
  }
  DVList dvl;
  
  equ.Info()["Temp"]=33.;
  equ.Info()["Texte"]="bla bla bla";
  cout << " scan initial " << endl;
  for( int j=0; j<10; j++ ) {
    cout << " pix no " << j << " val= " << equ(j) << endl;;
  }
  string sfile("scan.out");
  Scan equ2;
    {
    FIO_Scan fsc(equ); 
    fsc.Write(sfile);
    FIO_Scan gsc(sfile);
    equ2=(Scan)gsc;
      } 
  cout << " scan relu " << endl;
  for( int j=0; j<10; j++ ) 
    {
          cout << " pix no " << j << " val= " << equ2(j) << endl;
    }
  cout << " fin test persistance scan" << endl;
}
