#ifndef SWRAPSOCK_H
#define SWRAPSOCK_H

#include "machdefs.h"
#include "pexceptions.h"

#include <unistd.h>
#include <iostream>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>


namespace SOPHYA {

/*! 
  \class SocketException
  \ingroup SysTools
  \brief Exception class used by IP socket wrapper classes in SysTools module
*/

class SocketException : public PException {
  public:
  explicit SocketException(const char * m) : PException(m) {}
  explicit SocketException(const string& m) : PException(m) {}
};


//  --------------------------  
// Classe de base pour enrober l'initialisation et l'utilisation 
// des sockets pour les connections IP.
//  --------------------------   

class Socket {
public:
  Socket(int s=-1);
  Socket(Socket const & a);
  virtual ~Socket();

  size_t Send(const char * buff, size_t len, int flag=0);
  size_t Receive(char * buff, size_t len, int flag=0);
  size_t SendAll(const char * buff, size_t len);
  size_t ReceiveAll(char * buff, size_t len);

  virtual int Close();
  
  inline Socket& operator=(Socket const & a)
  { Set(a);  return (*this); }

  inline int SetPrtLevel(int lev=0) 
    { if (lev > 0) prtlev = lev; return prtlev; }
  inline long NBytesSent() { return totsnd; }
  inline long NBytesRecv() { return totrcv; }
  
protected:
  void Set(Socket const & a);

  int skt;
  long tstart;    /*  Temps de demarrage en sec  */
  long tlast;     /*  Temps de derniere acces en sec */
  long totrcv;    /*  Nb total d'octets recus  */
  long totsnd;    /*  Nb total d'octets envoyes */
  long dts;       /*  Dt en ms send (File or Data) */
  long nbbs;      /*  Nb Octets send (File or Data) */
  long dtr;       /*  Dt en ms recv (File or Data) */
  long nbbr;      /*  Nb Octets recv (File or Data) */
  long lstdt;     /*  Dt en ms last send or receive */
  long lstnbb;    /*  Nb bytes last send or receive */
  long errcnt;    /*  Total error count */
  int prtlev;
};


//  --------------------------  
//  Classe ServerSocket - A instancier cote serveur
//  --------------------------   

class ServerSocket : public Socket
{
public :
  ServerSocket(int port, int nconmax);
  Socket WaitClientConnection();
  virtual int Close();  // redefinition de la methode de Socket::Close()

protected:
  int portid;
  struct sockaddr_in  ipskt;
  int NConMax;
  int nclitot;  
};

//  --------------------------  
//  Classe ClientSocket - A instancier cote client
//  --------------------------   

class ClientSocket : public Socket
{
public :
  ClientSocket(string const& srvname, int port);
  ClientSocket(const char* srvname, int port);
  ClientSocket(ClientSocket const& a);
  inline ClientSocket& operator=(ClientSocket const& a)
  { SetC(a);  return (*this); }
protected:
  void SetC(ClientSocket const& a);
  void InitConnection(const char* srvname, int port);

  int portid;
  struct sockaddr_in  ipskt;

};

} // Fin du namespace

#endif
