#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <fstream>

#include "sopnamsp.h"
#include "histinit.h"
#include "dvlist.h"
#include "ntuple.h"
#include "datatable.h"
#include "swppfdtable.h"

/* --- Programme de test des classes  DVList, NTuple,          
    DataTable et les handlers PPF  
                               
   --- This code is part of the SOPHYA library ---
  (C) Univ. Paris-Sud   (C) LAL-IN2P3/CNRS   (C) IRFU-CEA
  (C) R. Ansari, C.Magneville    2000 - 2010   

   Appel: 
   #  Verification de DVList 
   csh> tnt d
   #  Verification de NTuple 
   csh> tnt n
   #  Verification de DataTable  
   csh> tnt DT 
   #  Verification de SwPPFDataTable  
   csh> tnt SWDT  
----------------------------------------------------------   */

void test_dvl();
void test_ntuple();
void test_DataTable() ; 
void test_SwPPFDataTable() ; 

int main(int narg, char *arg[])
{
  SophyaInit();
  if (narg < 2) {
    cout << " tnt/Erreur arg - Usage: tnt d/n/DT/SWDT \n" 
	 << " d:DVList n:NTuple DT,SWDT: SwPPF/DataTable test \n" << endl;
    exit(0);
  }
  int rc = 0;
  try {
    if (*arg[1] == 'd')  test_dvl();
    else if (*arg[1] == 'n')  test_ntuple();
    else if (strcmp(arg[1],"DT") == 0)  test_DataTable();
    else if (strcmp(arg[1],"SWDT") == 0)  test_SwPPFDataTable();
  }
  catch(PThrowable exc ) {
    cerr << "tnt-main() , Catched exception: \n" << exc.Msg() << endl;
    rc = 97;
  }
  catch(std::exception ex) {
    cerr << "tnt-main() , Catched exception ! " << (string)(ex.what()) << endl;
    rc = 98;
  }
  catch(...) {
    cerr << "tnt-main() , Catched ... ! " << endl;
    rc = 99;
  }
  return rc;
}

/*  ***** Test de NTuple simple ***** */
void test_ntuple()
{
  const char * names[3] = {"XPos", "YPos", "Val"};
  int i,j, k;
  float xnt[3];

  cout << "======= test_ntuple:  Testing NTuple ======= " << endl;

 cout << "Creation Ntuple avec X,Y,Val ... " << endl;
 NTuple  nt1(3, names, 20);

 k = 0;
 for(j=0; j<8; j++)
   for(i=0; i<12; i++)
     { xnt[0] = i+0.5;  xnt[1] = j+0.5;  xnt[2] = k;
     nt1.Fill(xnt); k++; }

 nt1.Info().Comment() = "NTuple de Test - Cree par tnt.cc";
 nt1.Info()["Version"] = SophyaVersion();
 nt1.Show(cout);
 nt1.Print(0, 5);
 nt1.Print(18, 5);
 nt1.Print(94, 5);

 string fn = "nt.ppf";
 {
  cout << "Ecriture NTuple ds nt.ppf ... \n" << endl;
  ObjFileIO<NTuple> fio(&nt1);
  fio.Write(fn);
 }

 {
   cout << "Lecture NTuple (nt2) ds nt.ppf ... \n" << endl;
   PInPersist fsi(fn);
   NTuple nt2; 
   fsi >> nt2;
   nt2.Show(cout);
   nt2.Print(0, 5);
   nt2.Print(18, 5);
   nt2.Print(94, 5);
 }


}

/*  ***** Test de dvlist ***** */
void test_dvl()
{
DVList dvl;

cout << "\n ======= test_dvl:  Testing MuTyV ======= " << endl;
MuTyV zvs = " ( 1.41 -2.71) ";
MuTyV dvs = "434.898";
MuTyV fvu = 314.1596;
MuTyV ivu = 7654321;
cout << " float->string: fvu= " << fvu << " (string)fvu=" << (string)fvu << endl;
cout << " int->string: ivu= " << ivu << " (string)ivu=" << (string)ivu << endl;
 complex<double> zzd = zvs;
cout << "String->complex<double>: zvs = " << zvs 
     << " (complex<double>)zvs= " << zzd << endl;
cout << "String->double: dvs = " << dvs 
     << " (double)dvs= " << (double)dvs << endl;
TimeStamp ts;
MuTyV tv = ts;
cout << "MuTyV=TimeStamp->String: tv = " << tv 
     << " ->double= " << (double)tv << " ->TimeStamp:" 
     << TimeStamp((double)tv).ToString() << endl;
tv = "1995-09-23T15:20:32";
string tts = (string)tv;
cout << "MuTyV=TimeStamp tv=" << tv << " ->TimeStamp(tv)=" 
     << TimeStamp(tts) << endl;

cout << "\n\n ======= test_dvl:  Testing DVList ======= " << endl;
dvl.SetI("Var XXX", 12345);
dvl.SetI("IV1-80", 80);
dvl.SetI("IV2-330", 330);

dvl.SetD("DV1-0.2", 0.2);
dvl.SetD("DV2-4.5", 4.5);
dvl.SetZ("ZV", complex<r_8>(2.0,-1.44));

dvl.SetI("IVV3-783", 783);
dvl("IVV3-783-O") =  7783;
// dvl["Avec[]"] =  "operateur [] !";
dvl.SetD("DVV3", 3.141592652141592652);
dvl.SetComment("DVV3", "Comment for DVV3, r_8 type variable");
dvl("DVV3avec()") =  44.555e-8; 

dvl.SetS("Blanc_White", "123.456Ma premiere chaine");
dvl.SetI("IntegerValue", 55777);
dvl.SetComment("IntegerValue", "This variable has a comment");
dvl.Comment() = "This is a test DVL produced by the program tdvl.cc \n Using SOPHYA , Feb 2000";

dvl["Sinf"] = "inf 0985";
dvl["ToDay"] = ts;
dvl.Print();


double d = dvl("DV2-4.5");
float f = dvl("DVV3");
int i = dvl("IVV3-783");
complex<r_8> z = dvl("ZV");

printf("\n \n Essai1 (IVV3 DVV3 DV2= ) %d  %.20g  %g \n", i, f, (float)d);
printf("\n \n Essai ZV= (%.2g  %g I) \n", z.real(), z.imag());
cout << "Test Comment/IntegerValue: " << dvl.GetComment("IntegerValue") << endl;
cout << "Test Comment/DVV3: " << dvl.GetComment("DVV3") << endl;

cout << "Test string recup  " << (string)(dvl["Blanc_White"]) << endl;
cout << "Test string recup(int=80)  " << (string)(dvl["IV1-80"]) << endl;
dvl("DVV3") = (double)3.141592652141592652;
cout << "Test string recup(double=Pi..i)  " << (string)(dvl["DVV3"]) << endl;

 {
   cout << " Writing DVList in file PPF dvl.ppf " << endl;
   POutPersist os("dvl.ppf");
   os << dvl ;
 }

 cout << "-------------------------- \n\n" 
      << " reading DVList from file dvl.ppf ... \n" << endl;

 DVList dvlr("dvl.ppf");
 double df1 = (double)( dvlr["DVV3"] );
 double df2 = (double)3.141592652141592652 - df1;
 cout << " Test Precision : Pi-Pi= " << df2  << "DVV3= " << df1 << endl;

 cout << dvlr;

}
void test_DataTable() 
{
  cout << "======= test_DataTable:  simple DataTable test ======= " << endl;
  DataTable dt(64);
  dt.AddIntegerColumn("line");
  dt.AddStringColumn("sline");
  dt.AddDoubleColumn("x");
  dt.AddFloatColumn("f_sin");
  dt.AddFloatColumn("f_cos");
  dt.AddDoubleColumn("f_sinxcos");
  dt.AddDoubleColumn("f_x2");
  dt.AddComplexColumn("cmplx_cos_sin");
  dt.AddDoubleComplexColumn("dcmplx_cos_sin");
  dt.AddDateTimeColumn("datime");
  MuTyV rec[10];
  TimeStamp ts("01/3/2005","0:0:0"); 
  TimeStamp ts2(0.);
  
  cout << " 1/ First 1000 lines .... " << endl;
  for(int k = 0; k<1000; k++) {
    rec[0] = k;
    string sline = "L-";
    sline += (string)rec[0];
    rec[1] = sline;
    double x = M_PI*k/100.;
    double fx = sin(x)*cos(x);
    double sx = sin(x);
    double cx = cos(x);
    rec[2] = x;
    rec[3] = sx;
    rec[4] = cx;
    rec[5] = fx;
    rec[6] = x*x;
    rec[7] = complex<r_4>(cx, sx);
    rec[8] = complex<r_8>(cx, sx);
    ts2.Set(ts.ToDays()+(double)k/24.);
    rec[9] = ts2;
    dt.AddLine(rec);
  }
  cout << "1.b/ Use of = operator to make copy of dt " << endl;
  DataTable dtc1;
  dtc1 = dt;

  dt.Show(); 
  cout << " 2/ Lines 1000-2000  .... " << endl;
  for(int k = 1000; k<2000; k++) {
    rec[0] = k;
    string sline = "L-";
    sline += (string)rec[0];
    rec[1] = sline;
    double x = M_PI*k/100.;
    double fx = sin(x)*cos(x);
    double sx = sin(x);
    double cx = cos(x);
    rec[2] = x;
    rec[3] = sx;
    rec[4] = cx;
    rec[5] = fx;
    rec[6] = x*x;
    rec[7] = complex<r_4>(cx, sx);
    rec[8] = complex<r_8>(cx, sx);
    ts2.Set(ts.ToDays()+(double)k/24.);
    rec[9] = ts2;
    dt.AddLine(rec);
  }
  cout << "2.b/ dt.Show();  : " << endl;
  dt.Show();  
  cout << "2.c/ dtc1.Show();  : " << endl;
  dtc1.Show();  
  cout << "2.d/  dt.LineHeaderToString() dt.LineToString(k)   : " << endl;
  cout << dt.LineHeaderToString() << endl;
  for(int k = 0; k<1500; k+=75) 
    cout << "Line[" << k << "] " << dt.LineToString(k) << endl ; 
  {
    cout << "3/ Writing DataTable dt to PPF stream dtable.ppf " << endl;
    POutPersist po("dtable.ppf");
    po << dt;
  }
  {
    cout << "4/ Reading DataTable dtr from PPF stream dtable.ppf " << endl;
    PInPersist pi("dtable.ppf");
    DataTable dtr;
    pi >> dtr;
    cout << "4.b/ cout << dtr; " << endl;
    cout << dtr;
    cout << "4.c/  dtr.LineHeaderToString() dtr.LineToString(k)   : " << endl;
    cout << dtr.LineHeaderToString() << endl;
    for(int k = 0; k<1500; k+=75) 
      cout << "Line[" << k << "] " << dtr.LineToString(k) << endl ; 
    
  }
  {
    cout << "5/ Reading DataTable dtr from text file dtable.txt " << endl;
    {
      cout << "5.a Writing lines to file dtable.txt " << endl; 
      ofstream os("dtable.txt");
      dt.Print(os,0,450);
    }
    cout << "5.b CopyStructure + FillFromASCIIFile from dtable.txt " << endl; 
    ifstream is("dtable.txt");
    DataTable dtr;
    dtr.CopyStructure(dt);
    dtr.FillFromASCIIFile(is);
    cout << dtr;
    cout << "5.c/  dtr.LineHeaderToString() dtr.LineToString(k)   : " << endl;
    cout << dtr.LineHeaderToString() << endl;
    for(int k = 0; k<10; k++) 
      cout << "Line[" << k << "] " << dtr.LineToString(k) << endl ; 
    for(int k = 50; k<300; k+=25) 
      cout << "Line[" << k << "] " << dtr.LineToString(k) << endl ; 
    
  }
  cout << "6./Test with DataTableRow object " << endl; 
  DataTable dtrow(64);
  dtrow.AddDoubleColumn("x");
  dtrow.AddFloatColumn("f_cos");
  dtrow.AddStringColumn("sline");
  dtrow.AddIntegerColumn("line");
  dtrow.AddDateTimeColumn("datime");

  DataTableRow row = dtrow.EmptyRow();
  for(int k = 0; k<25; k++) {
    MuTyV mtk = k;
    string sline = "L-";
    sline += (string)mtk;
    row["sline"] = sline;
    row["line"] = k;
    double x = M_PI*k/25.;
    double cx = cos(x);
    row[0] = x;
    row[1] = cx;
    ts2.Set(ts.ToDays()+(double)k);
    row["datime"] = ts2;
    dtrow.AddRow(row);
  }
  cout << dtrow << endl;
  cout << dtrow.LineHeaderToString() << endl;
  for(int k = 0; k<25; k+=3) {
    dtrow.GetRow(k, row);
    cout << "k=" << k << " GetRow():   " << row << endl;
    cout << " ...LineToString(): " << dtrow.LineToString(k) << endl;
  }
  cout << endl;
  cout << "============ FIN  test_DataTable ============== " << endl;  
}

void test_SwPPFDataTable() 
{
  cout << "======= test_SwPPFDataTable():  simple SwPPFDataTable test ======= " << endl;
  {
    POutPersist po("swdtable.ppf");
    SwPPFDataTable dt(po, 64);
    dt.AddIntegerColumn("line");
    dt.AddStringColumn("sline");
    dt.AddDoubleColumn("x");
    dt.AddFloatColumn("f_sin");
    dt.AddFloatColumn("f_cos");
    dt.AddDoubleColumn("f_sinxcos");
    dt.AddDoubleColumn("f_x2");
    dt.AddComplexColumn("cmplx_cos_sin");
    dt.AddDoubleComplexColumn("dcmplx_cos_sin");
    dt.AddDateTimeColumn("datime");
    MuTyV rec[10];
    TimeStamp ts("01/3/2005","0:0:0"); 
    TimeStamp ts2(0.);
    cout << " 1/ First 1000 lines .... " << endl;
    for(int k = 0; k<1000; k++) {
      rec[0] = k;
      string sline = "L-";
      sline += (string)rec[0];
      rec[1] = sline;
      double x = M_PI*k/100.;
      double fx = sin(x)*cos(x);
      double sx = sin(x);
      double cx = cos(x);
      rec[2] = x;
      rec[3] = sx;
      rec[4] = cx;
      rec[5] = fx;
      rec[6] = x*x;
      rec[7] = complex<r_4>(cx, sx);
      rec[8] = complex<r_8>(cx, sx);
      ts2.Set(ts.ToDays()+(double)k/24.);
      rec[9] = ts2;
      dt.AddLine(rec);
    }
    cout << "1.b/ Use of = operator to make copy of dt " << endl;
    SwPPFDataTable dtc1;
    dtc1 = dt;
    dt.Show(); 
    cout << " 2/ Lines 1000-2000  .... " << endl;
    for(int k = 1000; k<2000; k++) {
      rec[0] = k;
      string sline = "L-";
      sline += (string)rec[0];
      rec[1] = sline;
      double x = M_PI*k/100.;
      double fx = sin(x)*cos(x);
      double sx = sin(x);
      double cx = cos(x);
      rec[2] = x;
      rec[3] = sx;
      rec[4] = cx;
      rec[5] = fx;
      rec[6] = x*x;
      rec[7] = complex<r_4>(cx, sx);
      rec[8] = complex<r_8>(cx, sx);
      ts2.Set(ts.ToDays()+(double)k/24.);
      rec[9] = ts2;
      dt.AddLine(rec);
    }
    cout << "2.b/ dt.Show();  : " << endl;
    dt.Show();  
    cout << "2.c/ dtc1.Show();  : " << endl;
    dtc1.Show();  
    cout << "3/ Writing SwPPFDataTable dt to PPF stream swdtable.ppf " << endl;
    po << dt;
  }
  {
    cout << "4/ Reading SwPPFDataTable dtr from PPF stream swdtable.ppf " << endl;
    PInPersist pi("swdtable.ppf");
    SwPPFDataTable dtr;
    pi >> dtr;
    cout << "4.b/ cout << dtr; " << endl;
    cout << dtr;
    cout << "4.c/  dtr.LineHeaderToString() dtr.LineToString(k)   : " << endl;
    cout << dtr.LineHeaderToString() << endl;
    for(int k = 0; k<1500; k+=75) 
      cout << "Line[" << k << "] " << dtr.LineToString(k) << endl ;     
  }

  cout << "============ FIN  test_SwPPFDataTable() ======== ======= " << endl;  
}




