#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <iostream>

#include "sopnamsp.h"
#include "array.h"
#include "tarrinit.h"
#include "timing.h"
#include "ctimer.h"
#include "swrapsock.h"
#include "sockrawstream.h"
#include "burawstream.h"

// Numero de port pour la connection IP
#define PORTID 1962

void burawtst(); 
int serverside(const char* adr=NULL); 
int clientside(string& servname, string& msg, string& args);

static size_t RIOS_NPAQ = 16;
 
//---------------------------------------------------------------------------
//  main program de test des classes socket  - R. Ansari 2005-2008
//---------------------------------------------------------------------------
int main(int narg, char *arg[])
{
  cout << " ---- Programme tsok.cc - Test classes Socket --- " << endl;
  if (narg < 2) {
    cout << " Erreur Argument / tsok.cc : Socket class tests \n" 
         << "    Usage : tsok S/s/C [servername=localhost] [OPEMsg=Hello] [NLoop,SizeX,SizeY] [RIOS_NPaq=16]\n" 
         << "    Ex: tsok S   or  tsok C serverName or \n" 
         << "        tsok C serverName PPFSOCKET  5,1000,800 \n" 
         << "   S/s : run tsok as server side, (S: specify ServerSocket In_Adress)  \n" 
         << "   C : run tsok as client side \n"
         << "   OPEMsg : Operation select on client side (=XXX , PPFSOCKET , STOP)   \n"
         << "   serverName : Name or IP adress of the machine where tsok S is running \n" 
         << "   NLoop,SizeX,SizeY: Number of transfers, 2D array size for OPEMsg=PPFSOCKET \n" << endl;
    return 1;
  }  
  bool fgserv = false;
  bool fginadr = false;
  if (*arg[1] == 's')  fgserv = true;
  else if (*arg[1] == 'S') { fgserv=true;  fginadr=true; }
  string servname = "localhost";
  if (narg > 2)  servname = arg[2];
  string opemsg = "Hello";
  if (narg > 3) opemsg = arg[3];
  string oargs = "1,100,50";
  if (narg > 4) oargs = arg[4];
  if (narg > 5) RIOS_NPAQ = atol(arg[5]);

  int rc = 0;
  try {
    SophyaInit();  
    InitTim(); 
    if (fgserv) { 
      if (fginadr) rc=serverside(servname.c_str());
      else rc=serverside();
    }
    else if (*arg[1] == 'C') rc=clientside(servname, opemsg, oargs);
    else burawtst();
  }
  catch(PThrowable exc ) {
    cerr << "tsok-main() , Catched exception: \n" << exc.Msg() << endl;
    rc=97;
  }
  catch(std::exception ex) {
    cerr << "tsok-main() , Catched std::exception " << (string)(ex.what()) << endl;
    rc=98;
  }
  catch(...) {
    cerr << "tsok-main() , Catched ... ! " << endl;
    rc=99;
  }
  cout << " --------- End of tsok.cc Rc=" << rc << " ---------------- " << endl;
}


/* --Fonction-- */
int serverside(const char* adr)
{
  int rc = 66;
  cout << " ======== tsok.cc / ServerSide ============ " << endl;
  if (adr !=NULL)  cout << " Creating server socket InAddress=" << adr << ", PortId= " << PORTID << endl;
  else cout << " Creating server socket ... , PortId= " << PORTID << endl;
  ServerSocket srv(adr, PORTID, 1);
  bool fgstop = false;
  int nc = 0;
  while (!fgstop) {
    cout << " Waiting for client connection ... nc=" << nc << endl;
    Socket skt = srv.WaitClientConnection();
    nc ++;
    cout << " Connection established ... nc = " << nc << endl;
    bool fgbye = false;
    while (! fgbye) {
      char buff[256];
      for(int i=0; i<255; i++) buff[i] = '\0';
      size_t l = skt.Receive(buff, 256);
      buff[255] = '\0';
      cout << "Rcv/len=" << l << "Msg=" << buff << endl;
      if (l < 1) fgbye = true;
      else if (strncmp(buff,"STOP",4) == 0) fgstop = true;
      else if (strncmp(buff,"BYE",3) == 0) fgbye = true;
      else if (strncmp(buff,"PPFSOCKET", 9) == 0) {
        int nloop = 1;
        int sx = 100;
        int sy = 100;
        sscanf(buff+10,"%d,%d,%d",&nloop, &sx, &sy);
	cout << " ServerSide: Test SocketStream NLoop= " << nloop 
             << " Sx= " << sx << " Sy=" << sy << endl;
        Timer tm("tsok/Server");
        size_t totnkb = 0;
        for(int kl=0; kl<nloop; kl++) {
          ostringstream oss; 
          oss << " ServerSide/PPFSocket[" << kl <<"]"; 
          tm.Split(oss.str().c_str());
//          tm.Split("Server/StartRead");
          TMatrix<int_4> mx;
	//	cout << " waiting ... sleep(1) " << endl;
	//	sleep(1);
          {
	  RawInOutSocketStream sstr(skt, RIOS_NPAQ);
	  PInPersist pis(&sstr, false, false);
	  pis.GetObject(mx);
	  }
	  if (kl%5 == 0)  mx.Show() ;
          for(sa_size_t ir=0; ir<mx.NRows(); ir++)
            mx.Row(ir) += (int_4)(ir+3);
	  {
          // cout << " --- writing back modified mx to socket stream ... " << endl;
	  RawInOutSocketStream sstr(skt, RIOS_NPAQ);
	  POutPersist pos(&sstr, false);
	  pos.PutObject(mx);
	  }
          tm.Split("WriteBackDone");
          float tmillis = tm.PartialElapsedTime()*1000.;
          if (tmillis < 1.e-5) tmillis = 1e-5;
          cout << "ServerSide-Rate=" << 2.*(float)(mx.Size()*4)/tmillis << " kbytes/sec" << endl;
          totnkb += 2*mx.Size()*4/1000;

        }  // fin boucle kl->nloop

        float ttms  = tm.TotalElapsedTime();
        if (ttms < 1.e-6) ttms = 1e-6;
        cout << "  ===> Server/PPFSocket-MeanRate= " << (float)totnkb/ttms << " kbytes/sec" << endl;
      }  // fin if(PPFSOCKET)
    }  // fin while(! fgbye) 
    cout << "ServerSide: Closing current socket ..." << endl;
    skt.Close(); 
    rc = 0;
  }  // fin while(!fgstop)
  cout << " ======= End of tsok.cc / ServerSide ======== " << endl;
  return rc;
}

/* --Fonction-- */
int clientside(string& servname, string& msg, string& args)
{
  int rc = 77;
  cout << " ======== tsok.cc / ClientSide ============ " << endl;
  cout << "  ServerName= " << servname << " OpeMsg= " << msg << endl;
  cout << "  Creating client socket  ServerName= " << servname << endl;
  ClientSocket cli(servname, PORTID);
  char buff[256];
  string maa = msg;
  if (msg == "PPFSOCKET")  { maa += ' '; maa += args; } 
  strncpy(buff, maa.c_str(), 255);
  buff[255] = '\0';
  cout << "  Sending Message : " << buff << endl;
  cli.Send(buff, 256);
  rc = 0;
  if (msg == "PPFSOCKET") {
    rc = 7;
    int nloop = 1;
    int sx = 100;
    int sy = 100;
    sscanf(args.c_str(),"%d,%d,%d",&nloop, &sx, &sy);
    cout << " ClientSide: Test SocketStream NLoop= " << nloop 
         << " Sx= " << sx << " Sy=" << sy << endl;
    Timer tm("tsok/Client");
    size_t totnkb = 0;
    int npb = 0;
    for(int kl=0; kl<nloop; kl++) {
      ostringstream oss; 
      oss << "ClientSide/PPFSocket[" << kl <<"]";
      tm.Split(oss.str().c_str());
//      tm.Split("Client/StartSend");
      TMatrix<int_4> mx(sy, sx);
      //	cout << " waiting ... sleep(1) " << endl;
      mx = RandomSequence(RandomSequence::Flat, 50, 10);
      {
      // cout << " --- writing mx to socket stream ... " << endl;
      RawInOutSocketStream sstr(cli, RIOS_NPAQ);
      POutPersist pos(&sstr, false);
      pos.PutObject(mx);
      }
      TMatrix<int_4> mxr;
      {
      RawInOutSocketStream sstr(cli, RIOS_NPAQ);
      PInPersist pis(&sstr, false, false);
      pis.GetObject(mxr);
      }
      if (kl%5==0) mxr.Show();
      for(sa_size_t ir=0; ir<mx.NRows(); ir++)  {
        mxr.Row(ir) -= (int_4)(ir+3);
        mxr.Row(ir) -= mx.Row(ir);
      }
     // Check for correct return matrix
      int_4 rmin, rmax;
      mxr.MinMax(rmin, rmax);
      if ((rmin!=0) || (rmax!=0))  npb++;
      cout << " ClientSide/CheckReturnMinMax=" << rmin << "," << rmax << endl;
      tm.Split("ReadCheckDone");
      float tmillis = tm.PartialElapsedTime()*1000.;
      if (tmillis < 1.e-5) tmillis = 1e-5;
      cout << "ClientSide-Rate=" << 2.*(float)(mx.Size()*4)/tmillis << " kbytes/sec" << endl;
      totnkb += 2*mx.Size()*4/1000;
    }
    cout << "ClientSide/End of PPFSocket  NPb-Check-returnMatrix=" << npb << " /NLoop=" << nloop << endl;  
    if (npb==0) rc=0;
    else rc=70;
    float ttms  = tm.TotalElapsedTime();
    if (ttms < 1.e-6) ttms = 1e-6;
    cout << "  ===> MeanRate= " << (float)totnkb/ttms << " kbytes/sec" << endl;
  }
  strncpy(buff, "BYE", 255);
  cout << "  Sending Message : " << buff << endl;
  cli.Send(buff, 256);
  cout << " ======= End of tsok.cc / ClientSide ======== " << endl;
  return rc;
}


/* --Fonction-- */
void burawtst()
{
  cout << " --------- burawtst() ------------ " << endl;
  {
    char buff[10000];
    for(int k=0; k<10000; k++) buff[k] = k%256;
    RawInOutBuffStream sstr("xxx.str");
    for(int i=1; i<10; i++) {
      cout << "Appel RawInOutBuffStream.write(s, " << i*650 << endl;
      sstr.write(buff, i*650);
    }
  }
  Matrix mx(8,6);
  mx = RegularSequence();
  cout << mx;
  {
    cout << " --- writing mx to buff stream ... " << endl;
    RawInOutBuffStream sstr("ftsok.str");
    POutPersist pos(&sstr, false);
    pos.PutObject(mx);
  }
  {
    cout << " --- writing mx to file ... " << endl;
    POutPersist pos("ftsok.ppf");
    pos.PutObject(mx);
  }

  cout << " --------- FIN-burawtst() ------------ " << endl;
  
}
