#ifndef  BRBASEPROC_H_SEEN
#define  BRBASEPROC_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classes de threads de traitememt donnees BAORadio 
//----------------------------------------------------------------


#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>

#include "brpaqu.h"
#include "timestamp.h"  // include SOPHYA

using namespace std;

//---------------------------------------------------------------------
// Classe de base pour l'analyse donnees (paquets acquisition) BAORadio 
// Les classes de traitement des paquets BAORadio peuvent heriter de 
// cette classe de base BRBaseProcessor en redefinissant la methode Process()
//---------------------------------------------------------------------
class BRBaseProcessor : public SOPHYA::ZThread {
public:	
  BRBaseProcessor(RAcqMemZoneMgr& memgr, MemZaction mmact=MemZA_ProcA);
  
  MemZStatus SetMemZAction(MemZaction mmact=MemZA_ProcA);

  virtual void run();
  inline void Stop();
  inline void STOP() { stop_ = true; }	

  inline void setNameId(const char* nom, int id) 
  { bpnom_=nom;   bpid_=id;  }
  inline void setNameId(string nom, int id) 
  { bpnom_=nom;   bpid_=id;  }

protected:
  // Methode devant etre redefinie pour effectuer le traitement - appele pour chaque trigger  
  virtual int Process();  // renvoie 0 si OK, sinon, arret traitement 

  RAcqMemZoneMgr& memgr_;
  MemZaction mmact_;    // Definition de l'action sur les paquets (defaut=MemZA_ProcA)
  MemZStatus mmsta_;    // Statut associe a mmact_ (defaut=MemZS_ProcA)
  bool stop_;
  vector<Byte*> fbuff_;      // Vecteur de pointeur de zone memoire pour chaque fibre 
  vector<Byte*> fprocbuff_;   // Vecteur de pointeur de proc_zone_mem pour chaque fibre 
  vector<BRPaquet> vpaq_;   // Vecteur de BRPaquet pour chaque fibre
  vector<Byte*> vprocpaq_;  // Vecteur de pointeur de zone memoire pour donnees traitees de chaque paquet/fibre 
  vector<BRPaqChecker> vpchk_;
  vector<uint_8> vfgok_;    // Vecteur de flag si paquet OK pour chaque fibre
  vector<uint_8> curfc_;    // Vecteur de numero de FrameCounter pour chaque fibre
  vector<uint_8> fcfirst_;  // 
  vector<uint_8> ttfirst_;
  bool fgokallfibers_;      // true -> paquets for all fibers OK

  uint_8 totprocnpaq_; 
  SOPHYA::TimeStamp cts_;   // current time stamp, get from MemZoneMgr

  string bpnom_;    // nom du processeur
  int bpid_;        // numero d'identificateur 
};



#endif
