#include "pciewrap.h"
#include "brpaqu.h"

#include "racqumem.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <iostream>

using namespace SOPHYA;

//-----------------------------------------------------------------------
//  Classe PCIEWrapperInterface  ( virtuelle pure ) 
//-----------------------------------------------------------------------

/* --Methode-- */
PCIEWrapperInterface::PCIEWrapperInterface()
{
  SetMaxWaitEndDMA();
}

/* --Methode-- */
PCIEWrapperInterface::~PCIEWrapperInterface()
{
}

/* --Methode-- */
unsigned long PCIEWrapperInterface::SetMaxWaitEndDMA(unsigned int maxkwedma, unsigned int nretry)
{
  if (maxkwedma>1) { maxwaitenddmaloop_=maxkwedma*1000; maxretryenddma_=nretry; } 
  return maxwaitenddmaloop_;
}

//------------------------------------------------------------------
// Classe TestPCIWrapperNODMA : genere des paquets sans appel au DMA
//------------------------------------------------------------------
/* --Methode-- */
TestPCIWrapperNODMA::TestPCIWrapperNODMA(UInt32 sz, double lossrate) 
  : PCIEWrapperInterface() , size_(sz)
{
  data_ = new Byte[size_];
  srcdata_ = new Byte[10*size_];
  for(UInt32 kk=0; kk<10*size_; kk++)
    srcdata_[kk] = (Byte)(kk%200+20);
  frame_counter_ = 0;
  timetag_ = 0;
  tottransfer_ = 0;
  if (lossrate<0.)  lossrate=-lossrate;
  max_frcount_=(UInt32)lossrate;
  lossrate_ = lossrate-(double)max_frcount_;
  if (lossrate_<1.e-9) lossrate_=0.;
  cout << " TestPCIWrapperNODMA(PaqSz=" << sz << ",LossRate=" << lossrate 
       << " MaxFrameCount=" << max_frcount_ << ")" << endl;
}

/* --Methode-- */
TestPCIWrapperNODMA::~TestPCIWrapperNODMA()
{
  delete[] data_;
  delete[] srcdata_;	
}

/* --Methode-- */
UInt32 TestPCIWrapperNODMA::TransferSize()
{
  return size_;	
}

/* --Methode-- */
UInt64 TestPCIWrapperNODMA::TotTransferBytes()
{
  return tottransfer_;
}

/* --Methode-- */
Byte* TestPCIWrapperNODMA::GetData()
{
  if (frame_counter_>max_frcount_)  return NULL;
  if (lossrate_ > 1.e-9) {
    UInt32 dfc = 1; 
    while (rg_.Flat01()<lossrate_)  dfc++;
    frame_counter_ += dfc;
  }
  else frame_counter_ ++;
  timetag_ = frame_counter_ * size_ / 2;
  BRPaquet paq(data_, size_);
  paq.SetHDRMarker64(pchk_.HDRTag());
  paq.SetTRLMarker64(pchk_.TRLTag());
  UInt16 cfc = (frame_counter_%65535);
  paq.SetFrameCounter(cfc);
  paq.SetTimeTag(timetag_);
  paq.SetPaqLen((UInt16)((size_ - BRHDRSIZE - BRTRLSIZE)/4));
  Byte* bp = paq.Data1();
/*
  for(UInt32 kk=0; kk<paq.DataSize(); kk++) 
    bp[kk] = (Byte)(sin(0.0345*kk)*78.+127.5);
  UInt32 kkmax = paq.DataSize();
  for(UInt32 kk=0; kk<kkmax; kk++)
    bp[kk] = (Byte)(kk%200+20);
*/
  UInt32 off = (frame_counter_*size_/3)%(9*size_);
  memcpy(bp, srcdata_+off, paq.DataSize());
  tottransfer_ += size_;
  return data_;
}

/* --Methode-- */
void TestPCIWrapperNODMA::PrintStatus(ostream& os) 
{
  os << "TestPCIWrapperNODMA::Status, FrameCounter=" << frame_counter_ 
     << " TimeTag=" << timetag_ << endl;
}
