#ifndef  RACQURW_H_SEEN
#define  RACQURW_H_SEEN

//----------------------------------------------------------------
// ---- classes de threads pour lecture (transfert DMA) 
//      et ecriture disque pour acquisition   BAORadio       -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------

#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>
#include "sopnamsp.h"
#include "zthread.h"
#include "pciewrap.h"
#include "brtypes.h"
#include "brpaqu.h"
#include "brparam.h"
#include "minifits.h"

using namespace std;


// Quelques definitions globales
// Nombre maximum de fibres geres par les classes MultiReader / MultiDiskWriter
#ifndef MAXNBFIB
#define MAXNBFIB  32   
#endif

//-------------------------------------------------------
// Classe thread de lecture PCI-Express
//-------------------------------------------------------

class PCIEReader : public ZThread {
public:
  PCIEReader( PCIEWrapperInterface &pciw , uint_4 sizeFrame,uint_4 paqSize ,RAcqMemZoneMgr& mem, 
	      uint_4 nmax=100, BRDataFmtConv swapall=BR_SwapAll);	
  virtual void run(); 
   void Stop();
  inline void STOP() { stop_ = true; }	
    
protected:
  // Pour recuperer un pointeur sur la prochaine zone memoire devant recevoir un paquet
  inline Byte* NextPaqTarget()  {
    if ((mmbuf_ == NULL )||(targ_npaq_ >= max_targ_npaq)) 
      if (MZoneManage()) return NULL;
    Byte* rb=mmbuf_+targ_npaq_*packSize_;
    targ_npaq_++;
    return rb;
  }
  bool MZoneManage(bool clean=false);  // Renvoie true si probleme

  RAcqMemZoneMgr& memgr;
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  BRDataFmtConv swapall_;  // select data swap/format conversion for BRPaquet
  bool stop_;  
  unsigned int sizeFr_ ;
  PCIEWrapperInterface& pciw_;
  uint_4 packSize_;
  // Variables pour gerer la logique de  NextPaqTarget() qui cache l'acces a RAcqMemZoneMgr
  int mid_;  // Identificateur zone memoire
  uint_4 targ_npaq_;  // Numero de paquet dans une seule zone memoire 
  uint_4 max_targ_npaq; // =  mmgr.NbPaquets() = Max de targ_npaq_
  Byte* mmbuf_;  // Pointeur zone memoire rendu par RAcqMemZoneMgr 

};

//-------------------------------------------------------
// Classe thread de sauvegarde sur fichiers
//-------------------------------------------------------

class DataSaver : public ZThread {
public:	
  DataSaver(RAcqMemZoneMgr& mem, string& path, uint_4 nfiles=100, uint_4 nblocperfile=1, bool savesig=true);

  virtual void run(); 
  void Stop(); 
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  uint_4 nfiles_;  // Nombre maxi de fichiers cree
  uint_4 nblocperfile_;  // Nombre de bloc (zone memoire) mis dans un fichier
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites = nfiles * nblocperfile_
  bool savesig_; // Si false, pas d'ecriture des fichiers FITS du signal 
  bool stop_;  
  string path_;  
  struct sigaction act;
 
};

//-------------------------------------------------------
// Classe thread de lecture PCI-Express + Check 
//-------------------------------------------------------

class PCIEReaderChecker : public ZThread {
public:
  PCIEReaderChecker( PCIEWrapperInterface &pciw , uint_4 sizeFrame,uint_4 paqSize, RAcqMemZoneMgr& mem, 
		     uint_4 nmax=100, BRDataFmtConv swapall=BR_SwapAll);  
  virtual void run(); 
   void Stop();
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  BRDataFmtConv swapall_;  // select data swap/format conversion for BRPaquet
  bool stop_;  
  unsigned int sizeFr_ ;
  PCIEWrapperInterface& pciw_;
  uint_4 packSize_;
};
//------------------------------------------------------------------
// Classe thread de lecture PCI-Express multi fibre (ou multi DMA)
//------------------------------------------------------------------

class PCIEMultiReader : public ZThread {
public:
  PCIEMultiReader(vector<PCIEWrapperInterface*> vec_pciw , RAcqMemZoneMgr& mem, BRParList const& par);
  virtual void run(); 
   void Stop();
  inline void STOP() { stop_ = true; }	

protected: 
  // Permet d'avancer d'un paquet dans la zone - renvoie true si probleme
  inline bool MoveToNextTarget()  {
    if ((mmbuf_ == NULL )||(targ_npaq_ >= max_targ_npaq)) 
      if (MZoneManage()) return true;
    targ_npaq_++;
    return false;
  }
  inline Byte* GetPaquetTarget(int numfib)  {
    if ((mmbufib_[numfib] == NULL )||(targ_npaq_ > max_targ_npaq)||(targ_npaq_ == 0))  return NULL; 
    Byte* rb=mmbufib_[numfib]+(targ_npaq_-1)*packSizeInMgr_;
    return rb;
  }
  bool MZoneManage(bool clean=false);  // Renvoie true si probleme
  
  RAcqMemZoneMgr& memgr;
  BRParList par_;   // Parametres divers d'acquisition 

  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  BRDataFmtConv swapall_;  // select data swap/format conversion for BRPaquet
  bool stop_;  
  unsigned int sizeFr_ ;
  vector<PCIEWrapperInterface *> vec_pciw_;
  uint_4 packSize_;
  uint_4 packSizeInMgr_;
  uint_4 nbDma_;
  int mid_;  // Identificateur zone memoire
  uint_4 targ_npaq_;  // Numero de paquet dans une seule zone memoire 
  uint_4 max_targ_npaq; // =  mmgr.NbPaquets() = Max de targ_npaq_
  Byte* mmbuf_;  // Pointeur zone memoire rendu par RAcqMemZoneMgr 
  Byte* mmbufib_[MAXNBFIB];  // Pointeurs zone memoire de chaque fibre rendu par RAcqMemZoneMgr 

};



//----------------------------------------------------------------------------------------
// Classe thread de sauvegarde sur fichiers - gerant plusieurs fibres dans RAcqMemZoneMgr
//----------------------------------------------------------------------------------------

// --- Cette classe utilise les parametres globaux d'acquisition BRAcqConfig
class MultiDataSaver : public ZThread {
public:	
  MultiDataSaver(RAcqMemZoneMgr& mem);

  virtual void run(); 
  void Stop(); 
  inline void STOP() { stop_ = true; }	
protected:
  int  AddFitsKWStart(MiniFITSFile* mff, BRAcqConfig& acpar, TimeStamp& ts);
  int  AddFitsKWEnd(MiniFITSFile* mff, BRAcqConfig& acpar, TimeStamp& ts);

  RAcqMemZoneMgr& memgr;

  uint_4 nfiles_;  // Nombre maxi de fichiers cree
  uint_4 nblocperfile_;  // Nombre de bloc (zone memoire) mis dans un fichier
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites = nfiles * nblocperfile_
  bool savesig_; // Si false, pas d'ecriture des fichiers FITS du signal 
  bool stop_;  
  uint_8 framecnt_first_[MAXNBFIB];  // Numero de framecounter first  
  uint_8 framecnt_last_[MAXNBFIB];   // Numero de framecounter last  
  uint_8 timetag_first_[MAXNBFIB];  // TimeTag first  
  
};

#endif
