// archparam.h    parametres generaux...
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#ifndef ARCHPARAM_H
#define ARCHPARAM_H

struct ArchParam {
  struct AcqParam {
    double tBlock0;  // MJD du bloc numero zero...
    double perEch;   // periode d''echantillonage en secondes 
    AcqParam(); 
  };
  
  struct GeomParam {
    GeomParam(); 
  };
  
  struct SSTParam {
    bool soustPente;  // Decide que l'on soustrait une pente constante a la piste en cours
    bool analFine;
    SSTParam();  
  };


  AcqParam  acq;
  GeomParam geo;
  SSTParam  sst;
  
  void Dump();
};

extern ArchParam archParam;

#endif
