// toisvr.cc
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999


#include "toisvr.h"

TOISvr::TOISvr()
{}

void TOISvr::SetDirectory(string d) {
  iter.directory = d;
}

void TOISvr::AddFile(string f) {
  iter.files.insert(f);
}

void TOISvr::UseAuxGPS(AuxGPS* gps) {
  if (iter.auxGPS) delete iter.auxGPS;
  iter.auxGPS = gps;
}


void TOISvr::OnBoardRecorderFiles(bool x) {
  iter.isOnBoardRecorder = x;
}

  
void TOISvr::SetTimeInterval(double tStart, double tEnd) {
  if (tStart>0) iter.tStart = tStart;
  if (tEnd>0)   iter.tEnd = tEnd;
}
  
void TOISvr::AddInfo(TOIKind kind, int index, bool triggering, bool interp) {
  TOIIter::info i;
  i.kind = kind; 
  i.index = index;
  i.triggering = triggering;
  i.interpolated= interp;
  iter.infos.push_back(i);
}

void TOISvr::AddInfo(TOIKind kind, bool triggering, bool interp) {
  AddInfo(kind,0,triggering,interp);
}
  
TOIIter TOISvr::DoQuery() {
  //iter.Init();
  return iter;
}
