// archparam.cc    parametres generaux...
// Eric Aubourg         CEA/DAPNIA/SPP   septembre 1999

#include "archparam.h"
#include <iostream.h>

ArchParam archParam;

// constructeurs avec parametres par defaut adaptes au vol
// TRAPANI 99

ArchParam::AcqParam::AcqParam() 
: tBlock0   (1376.8358818),
  perEch    (0.005836818076)
{}

ArchParam::GeomParam::GeomParam() 
{}

ArchParam::SSTParam::SSTParam() 
:  soustPente   (true),
   analFine     (false)
{}


void ArchParam::Dump()
{
  cout << "***Archeops parameters\n";
  cout << " **ACQ\n";
  cout << "   tBlock0      " << acq.tBlock0    << "\n";
  cout << "   perEch       " << acq.perEch     << "\n";
  cout << " **GEOM\n";
  cout << " **SST\n";
  cout << "   soustPente   " << sst.soustPente << "\n";
  cout << "   analFine     " << sst.analFine   << "\n";
  cout << "***END" << endl;
}