// Lecture des fichiers chanum_?.ppf et recherche des visibilites ecrites dans les matrices d'acq
// > make OBJ=$CMVPROG/obj/ EXE=$CMVPROG/exe/ chanum_1210
#include "sopnamsp.h"
#include "machdefs.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fstream>
#include <iostream>
#include <string>
#include <algorithm>

#include "pexceptions.h"
#include "tvector.h"
#include "nbtrixx.h"

// > chanum_1210 -f 1375.0610351 -o CasA02Dec.csh ../../crt*/PittsDec10/CasA02Dec/chanum_*.ppf
// > chanum_1210 -f 1375.0610351 -o Crab03Dec.csh ../../crt*/PittsDec10/Crab03Dec/chanum_*.ppf
// > chanum_1210 -f 1382.5378418 -o Sun03Dec.csh  ../../crt*/PittsDec10/Sun03Dec/chanum_*.ppf
// > chanum_1210 -f 1390.0146484 -o CasA03Dec.csh ../../crt*/PittsDec10/CasA03Dec/chanum_*.ppf

int decode_numthread(string filein,string& dir);

//--------------------------- Fonctions de ce fichier   ------------------- 
void usage(void);
void usage(void)
{
cout<<"Usage: chanum_1210 [options] chanum_?.ppf ..."<<endl
    <<" -f F0MHz : 1ere frequence pour cette acquisition (def=0.)"<<endl
    <<" -T it0,it1 : selection fichier temps de it0 a it1 (def=\"0,99999\")"<<endl
    <<" -o fichier.csh : nom du fichier de sortie pour les commandes a lancer"<<endl;
}

//----------------------------------------------------
int main(int narg, char* arg[])
{
  string outname = "chanum_1210.csh";
  string seltime = "0,99999";
  double freq0 = 0.;

  char c;
  while((c = getopt(narg,arg,"hO:o:f:T:")) != -1) {
    switch (c) {
    case 'f' :
      freq0 = atof(optarg);
      break;
    case 'o' :
      outname = optarg;
      break;
    case 'T' :
      seltime = optarg;
      break;
    case 'h' :
    default :
      usage(); return -1;
    }
  }
  if(optind>=narg) {usage(); return -2;}

  vector<uint_4> vcode, vnth, vrow;
  vector<string> vdir;
  int nvisi = 0;
  for(int ifile=optind;ifile<narg;ifile++) {
    // --- lecture file
    string filein = arg[ifile];
    cout<<"..file: "<<filein<<endl;
    struct stat buffer;
    int status = stat(filein.c_str(),&buffer);
    if(status) {cout<<"!!!UNKNOWN FILE"<<endl; continue;}
    PInPersist pin(filein);
    TVector<uint_4> chanpairnum;
    if(pin.GotoNameTag("chanpairnum")) pin.GetObject(chanpairnum,"chanpairnum");
    else {cout<<"!!!UNKNOWN OBJECTchanpairnum "<<endl; continue;}
    // --- decodage repertoire et num thread
    string dir;
    int nth = decode_numthread(filein,dir);
    if(nth<0) {cout<<"!!!DECODING PB for thread number"<<endl; continue;}
    // --- lecture des paires et des infos
    for(int row=0;row<chanpairnum.Size();row++) {
      vcode.push_back(chanpairnum(row));
      vnth.push_back(nth);
      vrow.push_back(row);
      vdir.push_back(dir);
      nvisi++;
    }
  }
  cout<<"nread="<<nvisi<<endl;

  // sort
  TVector<uint_4> Vcode(vcode), IVcode(vcode.size());
  TabSortInd(Vcode.Size(),Vcode.Data(),IVcode.Data());

  // ecriture
  {
  ofstream ftxt(outname.c_str(), ofstream::out);
  cout<<"writing in "<<outname<<" (is_open="<<ftxt.is_open()<<")"<<endl;
  if(!ftxt) {cout<<"!!!!OPENING failed "<<outname<<endl; return -3;}
  ftxt << "#!/bin/csh" <<endl;
  int dupli = 0, ndupli = 0;
  nvisi = 0;
  for(uint_4 i=0;i<vcode.size();i++) {
    char str[512];
    sprintf(str,"time ${TACQEXE}/svv2mtx2_1210 -f %.7f -T %s",freq0,seltime.c_str());
    string argu = str;
    uint_4 ip = IVcode(i);
    uint_4 vcode_prec = (i>0) ? vcode[IVcode(i-1)]: 99999999;
    uint_4 vcode_suiv = (i<vcode.size()-1) ? vcode[IVcode(i+1)]: 99999999;
    uint_4 v1 = vcode[ip]/1000, v2 = vcode[ip]%100;
    sprintf(str," -v %d,%d",v1,v2); argu += str;  // numero de canaux acq [1,32]
    sprintf(str," -t %d",vnth[ip]); argu += str;  // numero de threads
    sprintf(str," -r %d",vrow[ip]); argu += str;  // ligne de la matrice acq
    // L'acq fait: <v1.conj(v2)>
    // Si v1 et v2 sont de parites differentes donc de cylindres differents
    //   on veut toujours avoir une visi <E.conj(W)> cad <impair.conj(pair)>
    bool doconj = false;
    if( v1%2==0 && v2%2!=0 ) {argu += " -C"; doconj = true;}  // v1 pair et v2 impair
    //  nom du fichier de sortie avec gestion des duplications
    if(vcode_suiv==vcode[ip] || vcode_prec==vcode[ip]) argu += " -D";
    if(vcode_prec==vcode[ip]) {
      dupli++;
      if(i==vcode.size()-1) ndupli += dupli;
    } else {
      ndupli += dupli;
      dupli = 0;
    }
    sprintf(str," -o visi%d_%02d_%02d.ppf",dupli,v1,v2); argu += str;
    argu += " "; argu += vdir[ip];  // repertoire des fichiers acq
    ftxt << argu <<endl;
    nvisi++;
    cout<<i<<" "<<ip<<" "<<vcode[ip]<<" "<<v1<<","<<v2<<" th="<<vnth[ip]<<" ro="<<vrow[ip]
        <<" du="<<dupli<<" cj="<<doconj<<" "<<vdir[ip]<<endl;
  }
  cout<<"nvisi tot="<<nvisi<<", number of duplicate="<<ndupli<<", nvisi="<<nvisi-ndupli<<" / 528"<<endl;
  ftxt << "exit 0" <<endl;
  }

  // script should be executable
  string chmod = "chmod a+x "; chmod += outname;
  system(chmod.c_str());

  return 0;
}

//-------------------------------------------------
int decode_numthread(string filein,string& dir)
{
  unsigned int p = filein.rfind("chanum_");
  if(p>=filein.size()) return -1;
  if(p<=1) dir = ""; else dir = filein.substr(0,p-1);
  const char * c = (filein.c_str() + p);
  int nth = -2;
  sscanf(c,"chanum_%d.ppf",&nth);
  //cout<<"\""<<filein<<"\" "<<p<<" \""<<c<<"\" "<<nth<<" \""<<dir<<"\""<<endl;
  return nth;
}

