#ifndef  BRPROCGAIN_H_SEEN
#define  BRPROCGAIN_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2011
// Classes de threads de traitememt donnees BAORadio 
//  Principales classes utilisables 
//  - BRGainCalculator (donnees FFT ou RAW apres BRFFTCalculator)
//  - BRFFTCalculator (donnees RAW) 
//----------------------------------------------------------------

#include "brproc.h"

using namespace std;

 
//---------------------------------------------------------------------
// Classe de traitement simple pour obtenir des spectres filtres des RFIs 
// que l'on appelle spectre de gain / voie
// a partir de donnees de type FFT (firmware FFT)
//---------------------------------------------------------------------
class BRGainCalculator : public BRMeanSpecCalculator
{
public:
  BRGainCalculator(RAcqMemZoneMgr& memgr, string outpath, uint_4 nmean=1000, 
  		       bool fgdatafft=true, bool fgsinglechan=false);
  virtual ~BRGainCalculator(); // Fait le nettoyage final , sauvegarde des objets ...

  void SetOnMedianFreqFilt(){forceMedianFreqFilter_ = true;}  


protected:

// appele par Process() pour traiter un groupe de paquets correspondant a une fenetre en temps
  virtual void ProcSpecWin(uint_8 numpaqstart, uint_8 numpaqend);  // appele fenetre par fenetre  

  virtual void SaveMedianSpectra();  // Pour sauver les spectres median dans un fichier


  bool forceMedianFreqFilter_; // if true force Median frequency filtering

  TMatrix< r_4 > medfiltspecmtx_;    // Matrice des spectres filtres 
  uint_8 nbwin4mean_;    // number of windows to perform the mean value of the filtered spectra
  uint_4 nummedianfile_; //index of the filtered spectra file 

}; 
#endif
