/*  ------------------------ Projet BAORadio -------------------- 
    Differentes configurations de l'interferometre 
    R. Ansari , C. Magneville - Juin 2010 
---------------------------------------------------------------  */

#ifndef INTERFCONFIGS_SEEN
#define INTERFCONFIGS_SEEN

#include "mdish.h"      
#include <vector>
#include <string> 


//-----------------------------------------------------------------------------------
//  Fonctions de creation de configuration d'interfero avec des dishs
//-----------------------------------------------------------------------------------

//  Filled square array of ndxnd dishes 
vector<Dish> CreateFilledSqConfig(int nd, double Ddish=5., double Eta=0.9);
//  Semi filled square array of ndxnd dishes 
vector<Dish> CreateSemiFilledSqConfig(int nd, double Ddish=5., double Eta=0.9);
//  Various semi-filled dish configurations  
vector<Dish> CreateConfigA(double Ddish=5., double Eta=0.9);
vector<Dish> CreateConfigB(double Ddish=5., double Eta=0.9);
vector<Dish> CreateConfigC(double Ddish=5., double Eta=0.9);
vector<Dish> CreateConfigD(double Ddish=5., double Eta=0.9);

// Configuration a 12 dishs - arrange en cylindres (4+4+4) 
vector<Dish> CreateConfigNancay12(double Ddish=5., double Eta=0.9);
// Configuration a 24 dishs - arrange en cylindres (6+6+0+6+0+6) 
vector<Dish> CreateConfigNancay24(double Ddish=5., double Eta=0.9);
// Configuration a 36 cylindres (6+6+6+6+6+6) 
vector<Dish> CreateConfigNancay36(double Ddish=5., double Eta=0.9);
// Configuration a 40 cylindres (8+8+0+8+0+8+0+8) 
vector<Dish> CreateConfigNancay40(double Ddish=5., double Eta=0.9);

// Configuration a 128 dishs - arrange en 8 cylindres de 15 dishs (CC0CC00C00C00C0C)
vector<Dish> CreateConfigNancay128(double Ddish=5., double Eta=0.9);

// Filled cylinder configuration 
vector<Dish> CreateFilledCylConfig(int ncyl,  int nRL, double cylW=10., double cylRL=0.5, 
				   double etaW=0.9, double etaRL=0.9, bool fgscid=true);

// ASKPAP/MeerKAT - cross arranged array of 11 dishes 
vector<Dish> CreateCrossConfig(double Ddish=12., double base=20., double Eta=0.95);  
// ASKPAP/MeerKAT - double hexagonal array of 12 dishes 
vector<Dish> CreateDoubleHexagonConfig(double Ddish=12., double radius1=60., double radius2=150., double Eta=0.95);  

#endif
