#include "interfconfigs.h"


//-----------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------
//  Fonctions de creation de configuration d'interfero avec des dishs
//-----------------------------------------------------------------------------------
/* --Fonction -- */
vector<Dish> CreateFilledSqConfig(int nd, double Ddish, double Eta)
{
  vector<Dish>  vd;
  int cnt=0;
  for(int i=0; i<nd; i++) 
    for(int j=0; j<nd; j++) {
      cnt++; 
      vd.push_back(Dish(cnt, i*Ddish, j*Ddish, Eta*Ddish));
    }
  cout << ">>>CreateFilledSqConfig(" << nd << "," << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateSemiFilledSqConfig(int nd, double Ddish, double Eta)
{
  vector<Dish>  vd;
  int cnt=0;
  int fgst=1;
  for(int i=0; i<nd; i++) {
    fgst = (fgst+1)%2;
    for(int j=0; j<nd; j++) {
      if (j%2==fgst)  continue;
      cnt++; 
      vd.push_back(Dish(cnt, i*Ddish, j*Ddish, Eta*Ddish));
    }
  }
  cout << ">>>CreateSemiFilledSqConfig(" << nd << "," << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigA(double Ddish, double Eta)
{
  vector<Dish>  vd;
  int cnt=0;
  for(int i=0; i<18; i++) {
    cnt++; vd.push_back(Dish(cnt, i*Ddish,0.,Eta*Ddish));
    cnt++; vd.push_back(Dish(cnt, i*Ddish, 17.*Ddish,Eta*Ddish));
    if ((i>0)&&(i<17)) {
      cnt++; vd.push_back(Dish(cnt,0.,i*Ddish,Eta*Ddish));
      cnt++; vd.push_back(Dish(cnt,17.*Ddish,i*Ddish,Eta*Ddish));
    }
  }
  cout << ">>>CreateConfigA(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigB(double Ddish, double Eta)
{
  vector<Dish>  vd;
  int cnt=0;
  /*
  for(int i=0; i<13; i++) {
    cnt++; vd.push_back(Dish(cnt, i*Ddish,0.,Eta*Ddish));
    cnt++; vd.push_back(Dish(cnt, i*Ddish, 12.*Ddish,Eta*Ddish));
    if ((i>0)&&(i<12)) {
      cnt++; vd.push_back(Dish(cnt,0.,i*Ddish,Eta*Ddish));
      cnt++; vd.push_back(Dish(cnt,12.*Ddish,i*Ddish,Eta*Ddish));
    }
  }
  for(int i=0; i<5; i++) {
    cnt++; vd.push_back(Dish(cnt, (i+4)*Ddish,4.*Ddish,Eta*Ddish));
    cnt++; vd.push_back(Dish(cnt, (i+4)*Ddish, 8.*Ddish,Eta*Ddish));
    if ((i>0)&&(i<4)) {
      cnt++; vd.push_back(Dish(cnt,4.*Ddish,(i+4)*Ddish,Eta*Ddish));
      cnt++; vd.push_back(Dish(cnt,8.*Ddish,(i+4)*Ddish,Eta*Ddish));
    }
  }
  */
  for(int i=0; i<11; i++) {
    cnt++; vd.push_back(Dish(cnt, i*Ddish,0.,Eta*Ddish));
    cnt++; vd.push_back(Dish(cnt, i*Ddish, 10.*Ddish,Eta*Ddish));
    if ((i>0)&&(i<10)) {
      cnt++; vd.push_back(Dish(cnt,0.,i*Ddish,Eta*Ddish));
      cnt++; vd.push_back(Dish(cnt,10.*Ddish,i*Ddish,Eta*Ddish));
    }
  }
  for(int i=0; i<7; i++) {
    cnt++; vd.push_back(Dish(cnt, (i+2)*Ddish, 2.*Ddish,Eta*Ddish));
    cnt++; vd.push_back(Dish(cnt, (i+2)*Ddish, 8.*Ddish,Eta*Ddish));
    if ((i>0)&&(i<6)) {
      cnt++; vd.push_back(Dish(cnt,2.*Ddish,(i+2)*Ddish,Eta*Ddish));
      cnt++; vd.push_back(Dish(cnt,8.*Ddish,(i+2)*Ddish,Eta*Ddish));
    }
  }
  for(int i=0; i<3; i++) {
    cnt++; vd.push_back(Dish(cnt, (i+4)*Ddish, 4.*Ddish,Eta*Ddish));
    cnt++; vd.push_back(Dish(cnt, (i+4)*Ddish, 6.*Ddish,Eta*Ddish));
    if ((i>0)&&(i<2)) {
      cnt++; vd.push_back(Dish(cnt,4.*Ddish,(i+4)*Ddish,Eta*Ddish));
      cnt++; vd.push_back(Dish(cnt,6.*Ddish,(i+4)*Ddish,Eta*Ddish));
    }
  }


  cout << ">>>CreateConfigB(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  return vd;
}


/* --Fonction -- */
vector<Dish> CreateConfigC(double Ddish, double Eta)
{
  vector<int_4> lesx, lesy;
  
  int max = 16;
  for(int i=0; i<4; i++) 
    for(int j=0; j<4; j++) {
      lesx.push_back(i); lesy.push_back(j);
      lesx.push_back(max-i); lesy.push_back(max-j);
      lesx.push_back(i); lesy.push_back(max-j);
      lesx.push_back(max-i); lesy.push_back(j);
    }
  
  for(int i=5; i<12; i+=2) {
    lesx.push_back(i); lesy.push_back(0);
    lesx.push_back(i); lesy.push_back(max);
    lesx.push_back(0); lesy.push_back(i);
    lesx.push_back(max); lesy.push_back(i);
  }
  
  for(int i=4; i<=12; i+=2) 
    for(int j=4; j<=12; j+=2) {
      lesx.push_back(i); lesy.push_back(j);
    }
  
  for(int i=5; i<=11; i+=2) {
    lesx.push_back(i); lesy.push_back(4);
    lesx.push_back(i); lesy.push_back(max-4);
    lesx.push_back(4); lesy.push_back(i);
    lesx.push_back(max-4); lesy.push_back(i);
  }
  
  EnumeratedSequence esx,esy;
  esx = 2,5;
  esy = 5,2;
  
  for(int k=0; k<esx.Size(); k++) {
    int_4 ix=esx.Value(k);
    int_4 iy=esy.Value(k);
    
    lesx.push_back(ix); lesy.push_back(iy);
    lesx.push_back(max-ix); lesy.push_back(iy);
    lesx.push_back(ix); lesy.push_back(max-iy);
    lesx.push_back(max-ix); lesy.push_back(max-iy);
  }
 cout << "CreateConfigC/Debug: -checkSize/lesx=" << lesx.size() << " -Check/lesy=" << lesy.size() << endl;
 
 vector<Dish> vd;
 int cnt=0;
 for(size_t i=0; i<lesx.size(); i++) {
   cnt++; vd.push_back(Dish(cnt, ((double)lesx[i])*Ddish,((double)lesy[i])*Ddish,Eta*Ddish));
 }

 cout << ">>>CreateConfigC(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;

 return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigD(double Ddish, double Eta)
{
EnumeratedSequence es;
es = 0,1,3,4,6,8,10,12,14,16,18,20,22,24,25,27,28;
vector<int_4> lesx, lesy;
for(int k=0; k<es.Size(); k++) {
  lesx.push_back(es.Value(k));   lesy.push_back(0);
  lesx.push_back(es.Value(k));   lesy.push_back(28);
}
for(int k=1; k<es.Size()-1; k++) {
  lesy.push_back(es.Value(k));   lesx.push_back(0);
  lesy.push_back(es.Value(k));   lesx.push_back(28);
}
for(int k=1; k<=5; k++) {
  lesy.push_back(k);   lesx.push_back(5);
  lesy.push_back(28-k);   lesx.push_back(28-5);
  if (k!=5) { 
    lesx.push_back(k);   lesy.push_back(5);
    lesx.push_back(28-k);   lesy.push_back(28-5);
  }

  lesy.push_back(k);   lesx.push_back(28-5);
  lesy.push_back(28-k);   lesx.push_back(5);
  if (k!=5) { 
    lesx.push_back(28-k);   lesy.push_back(5);
    lesx.push_back(k);   lesy.push_back(28-5);
  }
}

for(int k=6; k<=13; k++) {
  lesy.push_back(k);   lesx.push_back(k);
  lesy.push_back(28-k);   lesx.push_back(28-k);
  lesy.push_back(k);   lesx.push_back(28-k);
  lesy.push_back(28-k);   lesx.push_back(k);
}


lesx.push_back(14); lesy.push_back(14);

EnumeratedSequence esx,esy;
esx = 1,2,4;
esy = 12,11,13;

for(int k=0; k<esx.Size(); k++) {
  int_4 ix=esx.Value(k);
  int_4 iy=esy.Value(k);
  lesx.push_back(ix); lesy.push_back(iy);
  lesx.push_back(28-ix); lesy.push_back(iy);
  lesx.push_back(ix); lesy.push_back(28-iy);
  lesx.push_back(28-ix); lesy.push_back(28-iy);
  
  lesy.push_back(ix); lesx.push_back(iy);
  lesy.push_back(28-ix); lesx.push_back(iy);
  lesy.push_back(ix); lesx.push_back(28-iy);
  lesy.push_back(28-ix); lesx.push_back(28-iy);
 }  
for(int k=5; k<=13; k+=2) {
  lesy.push_back(k);   lesx.push_back(14);
  lesy.push_back(28-k);   lesx.push_back(14);
  lesy.push_back(14);   lesx.push_back(k);
  lesy.push_back(14);   lesx.push_back(28-k);
}

 cout << "CreateConfigD/Debug: -checkSize/lesx=" << lesx.size() << " -Check/lesy=" << lesy.size() << endl;
 
 vector<Dish> vd;
 int cnt=0;
 for(size_t i=0; i<lesx.size(); i++) {
   cnt++; vd.push_back(Dish(cnt, ((double)lesx[i])*Ddish,((double)lesy[i])*Ddish,Eta*Ddish));
 }

 cout << ">>>CreateConfigD(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
 return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigNancay12(double Ddish, double Eta)
{
  EnumeratedSequence esx,esy;
  esx = 0,1,3;
  esy = 0,1,2,3;

  vector<Dish> vd;
  int cnt=0;

  for(int ix=0; ix<esx.Size(); ix++) {
    for(int iy=0; iy<esy.Size(); iy++) {
      cnt++; 
      vd.push_back(Dish(cnt, ((double)esx.Value(ix))*Ddish,((double)esy.Value(iy))*Ddish,Eta*Ddish));
    }
  }
  cout << ">>>CreateConfigNancay12(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigNancay24(double Ddish, double Eta)
{
  EnumeratedSequence esx,esy;
  esx = 0,1,3,5;
  esy = 0,1,2,3,4,5;

  vector<Dish> vd;
  int cnt=0;

  for(int ix=0; ix<esx.Size(); ix++) {
    for(int iy=0; iy<esy.Size(); iy++) {
      cnt++; 
      vd.push_back(Dish(cnt, ((double)esx.Value(ix))*Ddish,((double)esy.Value(iy))*Ddish,Eta*Ddish));
    }
  }
  cout << ">>>CreateConfigNancay24(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigNancay36(double Ddish, double Eta)
{
  EnumeratedSequence esx,esy;
  esx = 0,1,2,3,4,5; 
  esy = 0,1,2,3,4,5; 

  vector<Dish> vd;
  int cnt=0;

  for(int ix=0; ix<esx.Size(); ix++) {
    for(int iy=0; iy<esy.Size(); iy++) {
      cnt++; 
      vd.push_back(Dish(cnt, ((double)esx.Value(ix))*Ddish,((double)esy.Value(iy))*Ddish,Eta*Ddish));
    }
  }
  cout << ">>>CreateConfigNancay36(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigNancay40(double Ddish, double Eta)
{
  EnumeratedSequence esx,esy;
  esx = 0,1,3,5,7;
  esy = 0,1,2,3,4,5,6,7;

  vector<Dish> vd;
  int cnt=0;

  for(int ix=0; ix<esx.Size(); ix++) {
    for(int iy=0; iy<esy.Size(); iy++) {
      cnt++; 
      vd.push_back(Dish(cnt, ((double)esx.Value(ix))*Ddish,((double)esy.Value(iy))*Ddish,Eta*Ddish));
    }
  }
  cout << ">>>CreateConfigNancay40(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateConfigNancay128(double Ddish, double Eta)
{
  EnumeratedSequence esx,esy;
  esx = 0,1,3,4,7,10,13,15; 
  esy = 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;

  vector<Dish> vd;
  int cnt=0;

  for(int ix=0; ix<esx.Size(); ix++) {
    for(int iy=0; iy<esy.Size(); iy++) {
      cnt++; 
      vd.push_back(Dish(cnt, ((double)esx.Value(ix))*Ddish,((double)esy.Value(iy))*Ddish,Eta*Ddish));
    }
  }
  cout << ">>>CreateConfigNancay128(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
  return vd;
}

/* --Fonction -- */
vector<Dish> CreateFilledCylConfig(int ncyl,  int nRL, double cylW, double cylRL, double etaW, double etaRL, bool fgscid)
{
  vector<Dish>  vd;
  int cnt=0;

  for(int i=0; i<ncyl; i++) 
    for(int j=0; j<nRL; j++) {
      cnt++;
      int rid = (fgscid) ? i+1 : cnt; 
      vd.push_back(Dish(rid, i*cylW, j*cylRL, etaW*cylW, etaRL*cylRL));
    }
  cout << ">>>CreateFilledCylConfig(" << ncyl << "," << nRL << "," << cylW << "," << cylRL << "," 
       << etaW << "," << etaRL << "," << ((fgscid)?" RId=CylNum":"Cnt") 
       << ") ---> NDishes=" << vd.size() << endl;

  return vd;
}

/* --Fonction -- */
vector<Dish> CreateCrossConfig(double Ddish, double base, double Eta)
{
  vector<Dish>  vd;
  int cnt=0;
  EnumeratedSequence esx,esy;
  esx = -6.,-2.,1.,3.,5.; 
  esy = -5.,-1.,2.,4.,6.; 
  
  cnt++;
  vd.push_back(Dish(cnt, 0., 0., Eta*Ddish));

  for(int k=0; k<esx.Size(); k++) {
    double fx=esx.Value(k);
    cnt++;
    vd.push_back(Dish(cnt, fx*base, 0., Eta*Ddish));
  }
  for(int k=0; k<esy.Size(); k++) {
    double fy=esy.Value(k);
    cnt++;
    vd.push_back(Dish(cnt, 0., fy*base, Eta*Ddish));
  }
 cout << ">>>CreateCrossConfig(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
 return vd;
}


/* --Fonction -- */
vector<Dish> CreateDoubleHexagonConfig(double Ddish, double radius1, double radius2, double Eta)
{
  vector<Dish>  vd;
  int cnt=0;
  double ang=0.;
  for(int i=0; i<6; i++) {
    double x=cos(ang)*radius1;
    double y=sin(ang)*radius1;
    cnt++;
    vd.push_back(Dish(cnt, x, y, Eta*Ddish));
    ang += M_PI/3.;
  }
  ang=M_PI/6.;
  for(int i=0; i<6; i++) {
    double x=cos(ang)*radius2;
    double y=sin(ang)*radius2;
    cnt++;
    vd.push_back(Dish(cnt, x, y, Eta*Ddish));
    ang += M_PI/3.;
  }
 cout << ">>>CreateDoubleHexagonConfig(" << Ddish << "," << Eta << ") ---> NDishes=" << vd.size() << endl;
 return vd;
}
