#include "racqumem.h"

using namespace SOPHYA;

//----------------------------------------------------------------
// ---- classes de gestion memoire pour acquisition BAORadio -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------

/* --Methode-- */
RAcqMemZoneMgr::RAcqMemZoneMgr(uint_4 nz, uint_4 np, uint_4 psz)
  : mex(true), nzones(nz), nfibres(1), npaq(np), paqsz(psz), procpaqsz(0), 
    fiber_id(1), stop_(false), runstate_(MemZR_Running)
{
  Init();
}

/* --Methode-- */
RAcqMemZoneMgr::RAcqMemZoneMgr(uint_4 nzon, uint_4 nfib, uint_4 npaq, uint_4 paqsz, uint_4 procsz)
  : mex(true), nzones(nzon), nfibres(nfib), npaq(npaq), paqsz(paqsz), procpaqsz(procsz), 
    fiber_id(nfib), stop_(false), runstate_(MemZR_Running)
{
  Init();
}

/* --Methode-- */
void RAcqMemZoneMgr::Init()
{
  St_MemZ st;

  st.serial = 0;
  st.act = (uint_4)MemZA_None;
  st.stat = (uint_4)MemZS_Free;
  for(int k=0; k<MXNACTMZM; k++) st.nbact[k] = 0;
  uint_8 mzsz = nfibres*npaq*paqsz;
  uint_8 procmzsz = nfibres*npaq*procpaqsz;

  for(unsigned int k=0; k<NbZones(); k++) {
    memzones.push_back(new Byte[mzsz] );
    states.push_back(st);
    auxdatap.push_back(new RAcqMZAuxData );
    if (procmzsz > 0)  procmemzones.push_back(new Byte[procmzsz] );
  }
  for(size_t k=0; k<NbFibres(); k++) fiber_id[k]=0;
  dummy_=0;
  serial_ = 0;
  SetFinalizedMask();
  SetProcSavedReadyMask();
}

/* --Methode-- */
RAcqMemZoneMgr::~RAcqMemZoneMgr()
{
  for(uint_4 k=0; k<NbZones(); k++) { 
    delete[] memzones[k]; 
    delete auxdatap[k];
    if (procpaqsz > 0) delete[] procmemzones[k];
  }
}

/* --Methode-- */
int RAcqMemZoneMgr::FindMemZoneId(MemZaction act)
// Recherche et renvoie une zone memoire compatible pour effectuer l'operation act
// Pour act = MemZA_Fill : Zone vide ou satisfaisant la condition mask_finalized_
// On recherche a chaque fois la zone ayant le plus petit numero de serie 
// cad le numero d'ordre de remplissage
// Pour ProcA/B/C on attend que la zone avec le plus petit numero soit disponible

{
  int rid = -1;
  if (stop_) return rid;
  if ((act != MemZA_Fill) && (act != MemZA_Save) && (act != MemZA_Proc) &&
      (act != MemZA_ProcA) && (act != MemZA_ProcB) && (act != MemZA_ProcC) &&
      (act != MemZA_ProcD) && (act != MemZA_ProcE) && (act != MemZA_ProcF) && 
      (act != MemZA_ProcG) && (act != MemZA_ProcH) && (act != MemZA_ProcI) && 
      (act != MemZA_ProcJ) &&
      (act != MemZA_SaveProc) ) return rid;

  mex.lock();
  uint_8 bestserial = serial_ + 5;
  while ((rid < 0)&&(!stop_)) {
    switch (act)  {
      case MemZA_Fill:
	if (rid < 0) for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && 
	      ((states[k].stat == MemZS_Free)||((states[k].stat&mask_finalized_)==mask_finalized_) )) {
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) { states[rid].act = MemZA_Fill; states[rid].stat = MemZS_Free; }
	break;
      case MemZA_Save:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && 
              (states[k].stat & MemZS_Filled) && !(states[k].stat & MemZS_Saved) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          } 
	}
	if (rid >= 0) states[rid].act = MemZA_Save; 
	break;
      case MemZA_Proc:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && 
              (states[k].stat & MemZS_Saved) && !(states[k].stat & MemZS_Proc) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_Proc;  
        break; 	      	  
      case MemZA_ProcA:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              !(states[k].stat & MemZS_ProcA) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcA;   	      	  
	break;
      case MemZA_ProcB:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcA) && !(states[k].stat & MemZS_ProcB) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcB;   	      	  
	break;
      case MemZA_ProcC:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcB) && !(states[k].stat & MemZS_ProcC) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcC;   	      	  
	break;
      case MemZA_ProcD:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcC) && !(states[k].stat & MemZS_ProcD) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcD;   	      	  
	break;
      case MemZA_ProcE:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcD) && !(states[k].stat & MemZS_ProcE) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcE;   	      	  
	break;
      case MemZA_ProcF:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcE) && !(states[k].stat & MemZS_ProcF) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcF;   	      	  
	break;
      case MemZA_ProcG:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcF) && !(states[k].stat & MemZS_ProcG) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcG;   	      	  
	break;
      case MemZA_ProcH:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcG) && !(states[k].stat & MemZS_ProcH) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcH;   	      	  
	break;
      case MemZA_ProcI:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcH) && !(states[k].stat & MemZS_ProcI) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcI;   	      	  
	break;
      case MemZA_ProcJ:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
              (states[k].stat & MemZS_ProcI) && !(states[k].stat & MemZS_ProcJ) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          }
	}
	if (rid >= 0) states[rid].act = MemZA_ProcJ;   	      	  
	break;
      case MemZA_SaveProc:
	for(uint_4 k=0; k<NbZones(); k++) {
	  if ((states[k].act == MemZA_None) && 
              (states[k].stat & mask_saveproc_ready_) && !(states[k].stat & MemZS_SavedProc) ) { 
            if (states[k].serial < bestserial) { rid=k; bestserial=states[k].serial; } 
          } 
	}
	if (rid >= 0) states[rid].act = MemZA_SaveProc; 
	break;
      case MemZA_None:   // MTQ pour supprimer un warning
	break;
      }  // Fin de switch 
    if (rid < 0)  mex.wait();
  }  // Fin de while 
  mex.unlock();
  return rid;
}

/* --Methode-- */
int RAcqMemZoneMgr::FreeMemZone(int id, MemZStatus st)
{
  if ((id < 0) || (id >= (int)states.size()))  return 1;
  int rc = 0;
  mex.lock();
  switch (st) {
    case MemZS_Free :
      states[id].serial = 0;
      states[id].stat = MemZS_Free; 
      states[id].act = MemZA_None;
      break;
    case MemZS_Filled :
      if (states[id].act != MemZA_Fill)  rc = 2;
      else states[id].nbact[0]++;
      serial_ ++;
      states[id].serial = serial_;
      states[id].stat |= MemZS_Filled; 
      states[id].act = MemZA_None;
      break;
    case MemZS_Saved :
      if (states[id].act != MemZA_Save)  rc = 4;
      else states[id].nbact[1]++;  	  
      states[id].stat |= MemZS_Saved; 
      states[id].act = MemZA_None;
      break;
    case MemZS_Proc :
      if (states[id].act != MemZA_Proc)  rc = 8;
      else states[id].nbact[2]++;  	  
      states[id].stat |= MemZS_Proc; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcA :
      if (states[id].act != MemZA_ProcA)  rc = 16;
      else states[id].nbact[3]++;  	  
      states[id].stat |= MemZS_ProcA; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcB :
      if (states[id].act != MemZA_ProcB)  rc = 32;
      else states[id].nbact[4]++;  	  
      states[id].stat |= MemZS_ProcB; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcC :
      if (states[id].act != MemZA_ProcC)  rc = 64;
      else states[id].nbact[5]++;  	  
      states[id].stat |= MemZS_ProcC; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcD :
      if (states[id].act != MemZA_ProcD)  rc = 128;
      else states[id].nbact[6]++;  	  
      states[id].stat |= MemZS_ProcD; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcE :
      if (states[id].act != MemZA_ProcE)  rc = 256;
      else states[id].nbact[7]++;  	  
      states[id].stat |= MemZS_ProcE; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcF :
      if (states[id].act != MemZA_ProcF)  rc = 512;
      else states[id].nbact[8]++;  	  
      states[id].stat |= MemZS_ProcF; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcG :
      if (states[id].act != MemZA_ProcG)  rc = 1024;
      else states[id].nbact[9]++;  	  
      states[id].stat |= MemZS_ProcG; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcH :
      if (states[id].act != MemZA_ProcH)  rc = 2048;
      else states[id].nbact[10]++;  	  
      states[id].stat |= MemZS_ProcH; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcI :
      if (states[id].act != MemZA_ProcI)  rc = 4096;
      else states[id].nbact[11]++;  	  
      states[id].stat |= MemZS_ProcI; 
      states[id].act = MemZA_None;
      break;
    case MemZS_ProcJ :
      if (states[id].act != MemZA_ProcJ)  rc = 4096;
      else states[id].nbact[12]++;  	  
      states[id].stat |= MemZS_ProcJ; 
      states[id].act = MemZA_None;
      break;
    case MemZS_SavedProc :
      if (states[id].act != MemZA_SaveProc)  rc = 16384;
      else states[id].nbact[13]++;  	  
      states[id].stat |= MemZS_ProcF; 
      states[id].act = MemZA_None;
      break;
    default :
      rc = 65536;
      states[id].serial = 0;
      states[id].stat = MemZS_Free; 
      states[id].act = MemZA_None;
      break;
  }  // Fin de switch 
  mex.unlock();
  mex.broadcast();
  return rc;
}

/* --Methode-- */
ostream& RAcqMemZoneMgr::Print(ostream& os)
{
  os << "RAcqMemZoneMgr::Print() NbZones=" << NbZones() << " PaqSize()=" << PaqSize()
     << " NbPaquets()=" << NbPaquets() << " NbFibres()=" << NbFibres() << " ZoneSize()=" 
     << ZoneSize() << endl;
  if (ProcPaqSize() > 0)  
    cout << " ... With Processed Data Zones ProcPaqSize()=" << ProcPaqSize() 
         << " ProcZoneSize()=" << ProcZoneSize() << endl;
  else cout << " ... NO Processed Data Zones" << endl;
  for(uint_4 k=0; k<states.size(); k++) {
    os << " [" << k << "] Act=" << states[k].act << " Stat=" << states[k].stat 
       << " NbAct[0.."<< MXNACTMZM-1 << "]=" << states[k].nbact[0];
    for(uint_4 j=1; j<MXNACTMZM; j++)  cout << "," << states[k].nbact[j];
    cout << endl;
  }
  return os;   
}

/* --Methode-- */
void RAcqMemZoneMgr::Stop()
{
  //  cout << "RAcqMemZoneMgr::Stop() ........ STOP                          BROADCAST" <<endl; 
  stop_ = true;
  runstate_ = MemZR_Stopped;
  mex.broadcast();
}

/* --Methode-- */
MemZaction RAcqMemZoneMgr::Convert_Status2Action(MemZStatus st)
// methode statique 
{
  MemZaction ra=MemZA_None;
  switch (st) {
  case MemZS_Filled:
    ra=MemZA_Fill;
    break;
  case MemZS_Saved:
    ra=MemZA_Save;
    break;
  case MemZS_Proc:
    ra=MemZA_Proc;
    break;
  case MemZS_ProcA:
    ra=MemZA_ProcA;
    break;
  case MemZS_ProcB:
    ra=MemZA_ProcB;
    break;
  case MemZS_ProcC:
    ra=MemZA_ProcC;
    break;
  case MemZS_ProcD:
    ra=MemZA_ProcD;
    break;
  case MemZS_ProcE:
    ra=MemZA_ProcE;
    break;
  case MemZS_ProcF:
    ra=MemZA_ProcF;
    break;
  default:
    ra=MemZA_None;
    break;
  }
  return ra;
}
