//  Definition de la carte synchrotron/radio sources ...
//  Projet BAORadio , Juin 2010 

#ifndef CUBEDEF_SEEN
#define CUBEDEF_SEEN

// Definition tailles et bornes du cube angles (X,Y), frequence (Z)

static sa_size_t NTheta=600;
static sa_size_t NPhi=800;
static sa_size_t NFreq = 256;

// Carte 30x50 deg, centre en delta = +10 deg , alpha= 150 deg = 10h00
static double Theta0Degre = 65.;  // -> Delta = +30 deg
static double Phi0Degre = 130.;   // -> alpha = 8.66 heures 
static double ThetaSizeDegre = 30.;  // Taille de la carte en degre selon alpha (axe X)
static double PhiSizeDegre = 40.;    // Taille de la carte en degre selon delta (axe Y)

/* ---  Parametres avec generation Reza from HASLAM + NVSS 
static double Freq0MHz = 875.;       // premiere frequence 
static double FreqSizeMHz = 70.4;    // Taille de la carte en MHz (axe Z)

// z = 0.56, freq_center=910 MHz , dA_comov ~= 2060 Mpc ,  
//       5 arcmin -> 3 Mpc , 0.500 MHz -> 3 Mpc  (H(ze) ~ 94 km/s/Mpc)
// Taille de cellule pour le calcul du spectre de puissance 3D 
static double ComovDA = 2060.;
static double XCellSizeMpc = 3.;
static double YCellSizeMpc = 3.;
static double ZCellSizeMpc = 1.5;
*/

/* --- Parametres pour utilisation des cartes GSM  */
static double Freq0MHz = 820.;       // premiere frequence 
static double FreqSizeMHz = 128.;    // Taille de la carte en MHz (axe Z)

// z = 0.6, freq_center=884 MHz , dA_comov ~= 2185 Mpc ,  
//       5 arcmin -> 3 Mpc (3.17 Mpc) , 0.550 MHz -> 3 Mpc  (H(ze) ~ 96 km/s/Mpc)
//       3 arcmin -> 1.9 Mpc, 0.5 MHz -> 2.8 Mpc 
// Taille de cellule pour le calcul du spectre de puissance 3D 
static double ComovDA = 2185.;
static double XCellSizeMpc = 1.9;
static double YCellSizeMpc = 1.9;
static double ZCellSizeMpc = 2.8;
// Nb de bin de HProf pour calcul P(k)
static int HPk_NBin = 384;


//---  Parametres des lois de puissance en frequence 
static double AmpPL1 = 1.;   // amp max PowerLaw 1 (synchrotron  
static double PLidx1 = -2.8;  // index de la loi de puissance synchrotron 
static double sigPLidx1 = 0.1;  // Sigma de la variation (gaussienne) de index1 
// Amplitude max de la 2eme composante en loi de puissance (tirage plat 0 ... AmpPL2)
static double AmpPL2 = 0.1;   // amp max PowerLaw 2 
static double PLidx2 = -3.2; 
static double sigPLidx2 = 0.15;

// Generation de la loi de puissance des sources : 
static double PLidxSrc = -2.0;  // index de la loi de puissance des sources  
static double sigPLidxSrc = 0.15;  // Sigma de la variation (gaussienne) de l'index  

/*
static sa_size_t NTheta=256;
static sa_size_t NPhi=256;
static sa_size_t NFreq = 128;

static double Theta0Degre = 60.;  // -> Delta = +30 deg
static double Phi0Degre = 120.;   // -> alpha = 8h00
static double ThetaSizeDegre = 60.;  // Taille de la carte en degre selon alpha (axe X)
static double PhiSizeDegre = 60.;    // Taille de la carte en degre selon delta (axe Y)
static double Freq0MHz = 840.;       // premiere frequence 
static double FreqSizeMHz = 100.;    // Taille de la carte en MHz (axe Z)
*/

#endif
