//  Definition de la carte synchrotron/radio sources ...
//  Projet BAORadio , Juin 2010 

#ifndef CUBEDEF_SEEN
#define CUBEDEF_SEEN

//------- Definition tailles et bornes du cube angles (X,Y), frequence (Z) -----
// Cartes DPhi=40 degre x DTheta= 30 degre, 3x3 arcmin^2 de resolution  
static sa_size_t NTheta=600;
static sa_size_t NPhi=800;
static sa_size_t NFreq = 256;

// Carte 30x50 deg, centre en delta = +10 deg , alpha= 150 deg = 10h00
static double Theta0Degre = 65.;  // -> Delta = +30 deg
static double Phi0Degre = 130.;   // -> alpha = 8.66 heures 
static double ThetaSizeDegre = 30.;  // Taille de la carte en degre selon alpha (axe X)
static double PhiSizeDegre = 40.;    // Taille de la carte en degre selon delta (axe Y)

/* Cartes DPhi=90 degre x DTheta= 30 degre, 3x3 arcmin^2 de resolution  
static sa_size_t NTheta=600;
static sa_size_t NPhi=1800;
static sa_size_t NFreq = 256;

// Carte 30x50 deg, centre en delta = +10 deg , alpha= 150 deg = 10h00
static double Theta0Degre = 65.;  // -> Delta = +30 deg
static double Phi0Degre = 105.;   // -> alpha = 7 heures 
static double ThetaSizeDegre = 30.;  // Taille de la carte en degre selon alpha  (axe X)
static double PhiSizeDegre = 90.;    // Taille de la carte en degre selon delta (axe Y)
*/

/* --- Parametres pour utilisation des cartes GSM  */
static double Freq0MHz = 820.;       // premiere frequence a z=0.6
// static double Freq0MHz = 646.;         premiere frequence z=1.0
// static double Freq0MHz = 504.;         premiere frequence z=1.5

static double FreqSizeMHz = 128.;    // Taille de la carte en MHz (axe Z)

// z = 0.6, freq_center=884 MHz , dA_comov ~= 2185 Mpc ,  
//       5 arcmin -> 3 Mpc (3.17 Mpc) , 0.550 MHz -> 3 Mpc  (H(ze) ~ 96 km/s/Mpc)
//       3 arcmin -> 1.9 Mpc, 0.5 MHz -> 2.8 Mpc 
// z = 1.0, freq_center=710 MHz , dA_comov ~= 3330 Mpc ,  
//       3 arcmin -> 2.88 Mpc, 0.5 MHz -> 3.5 Mpc 
// z = 1.5, freq_center=504 MHz , dA_comov ~= 4390 Mpc ,  
//       3 arcmin -> 3.83 Mpc, 0.5 MHz -> 4.2 Mpc 

// Taille de cellule pour le calcul du spectre de puissance 3D 
// z=0.6
static double ComovDA = 2185.;
static double XCellSizeMpc = 1.9;
static double YCellSizeMpc = 1.9;
static double ZCellSizeMpc = 2.8;
/* z=1.0
static double ComovDA = 3300.;
static double XCellSizeMpc = 2.9;
static double YCellSizeMpc = 2.9;
static double ZCellSizeMpc = 3.5;
*/
/* z=1.5
static double ComovDA = 4390.;
static double XCellSizeMpc = 3.8;
static double YCellSizeMpc = 3.8;
static double ZCellSizeMpc = 4.2;
*/

// Nb de bin de HProf pour calcul P(k)
static int HPk_NBin = 384;

// --- Carte HASLAM 
static double FreqHASLAM = 408.;   // frequence carte HASLAM en MHz 
 
//---  Parametres des lois de puissance en frequence 
static double AmpPL1 = 1.;   // amp max PowerLaw 1 (synchrotron  
static double PLidx1 = -2.8;  // index de la loi de puissance synchrotron 
static double sigPLidx1 = 0.15;  // Sigma de la variation (gaussienne) de index1 
// Amplitude max de la 2eme composante en loi de puissance (tirage plat 0 ... AmpPL2)
static double AmpPL2 = 0.;   // amp max PowerLaw 2 0. ---> pas de  
static double PLidx2 = -3.2; 
static double sigPLidx2 = 0.15;

// Generation de la loi de puissance des sources : generation plate ds [PLidxSrcMin,PLidxSrcMax 
static double PLidxSrcMin = -2.;  // index mini de la loi de puissance des sources
static double PLidxSrcMax = -1.5;  // index maxi de la loi de puissance des sources  
  
/*
static sa_size_t NTheta=256;
static sa_size_t NPhi=256;
static sa_size_t NFreq = 128;

static double Theta0Degre = 60.;  // -> Delta = +30 deg
static double Phi0Degre = 120.;   // -> alpha = 8h00
static double ThetaSizeDegre = 60.;  // Taille de la carte en degre selon alpha (axe X)
static double PhiSizeDegre = 60.;    // Taille de la carte en degre selon delta (axe Y)
static double Freq0MHz = 840.;       // premiere frequence 
static double FreqSizeMHz = 100.;    // Taille de la carte en MHz (axe Z)
*/

#endif
