#ifndef  BRBASEPROC_H_SEEN
#define  BRBASEPROC_H_SEEN

//----------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2011
// Classes de threads de traitememt donnees BAORadio 
//----------------------------------------------------------------


#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>

#include "brpaqu.h"
#include "timestamp.h"  // include SOPHYA

using namespace std;

//---------------------------------------------------------------------
// Classe de base pour l'analyse donnees (paquets acquisition) BAORadio 
// Les classes de traitement des paquets BAORadio peuvent heriter de 
// cette classe de base BRBaseProcessor en redefinissant la methode Process()
//---------------------------------------------------------------------
class BRBaseProcessor : public SOPHYA::ZThread {
public:	
  BRBaseProcessor(RAcqMemZoneMgr& memgr, MemZaction mmact=MemZA_ProcA);
  
  MemZStatus SetMemZAction(MemZaction mmact=MemZA_ProcA);

  virtual void run();

  inline void Stop() { stop_ = true; }	
  inline void STOP() { stop_ = true; }	

  inline void setNameId(const char* nom, int id) 
  { bpnom_=nom;   bpid_=id;  }
  inline void setNameId(string const& nom, int id) 
  { bpnom_=nom;   bpid_=id;  }

  // Definition de la fentre en temps des paquets a traiter - par defaut, traitement de tous les paquets 
  // Process() est alors appele pour les paquets des zones MemZoneMgr
  // avec TimeStart <= getObsTime() <= TimeEnd 
  inline void SetProcTimeWindow(SOPHYA::TimeStamp tmstart, SOPHYA::TimeStamp tmend) 
  {  tmstart_=tmstart; tmend_=tmend; fgproctimewin_=true; }
  // Annulation de la definition de la fenetre de traitement en temps
  inline void ClearProcTimeWindow() 
  {  fgproctimewin_=false; } 

  // get Observation Time ( obtained from MemZoneMgr )
  inline SOPHYA::TimeStamp& getObsTime()  { return cts_; }
  // get Obsservation time in seconds since the start date 
  // Temps ecoule en seconde a partir de 0h00 de la date du premier fichier
  inline double getObsTimeSeconds() { return ((cts_.DaysPart()-startdate_)*86400.+cts_.SecondsPart()); }

  // Attention : les methodes suivantes ne sont pas protegees pour le numero de fibre
  // Renvoie le numero de frame-counter courant - si fgz=true, soustrait le FC du premier paquet 
  inline uint_8 getCurFrameCounter(size_t fib=0, bool fgz=true) 
  { if (fgz) return (curfc_[fib]-fcfirst_[fib]) ;  else return curfc_[fib]; }
  // Renvoie le TimeTag courant (unite coups d'horloge) - si fgz=true, soustrait le TT du premier paquet 
  inline uint_8 getCurTimeTag(size_t fib=0, bool fgz=true) 
  { if (fgz) return (vpaq_[fib].TimeTag()-ttfirst_[fib]) ;  else return vpaq_[fib].TimeTag(); }
  // Renvoie le TimeTag courant converti en secondes  - si fgz=true, soustrait le TT du premier paquet 
  inline double getCurTimeTagSeconds(size_t fib=0, bool fgz=true) 
  { 
    if (fgz) return ((double)(vpaq_[fib].TimeTag()-ttfirst_[fib])/1.25e8) ;  
    else return ((double)vpaq_[fib].TimeTag()/1.25e8); 
  }
  //---- niveau d'impression 
  inline void SetPrintLevel(int lev=0, uint_8 prtmodulo=10) 
    { prtlev_=lev;   prtmodulo_=prtmodulo;}

protected:
  // Methode devant etre redefinie pour effectuer le traitement - appele pour chaque trigger  
  virtual int Process();  // renvoie 0 si OK, sinon, arret traitement 

  RAcqMemZoneMgr& memgr_;
  MemZaction mmact_;    // Definition de l'action sur les paquets (defaut=MemZA_ProcA)
  MemZStatus mmsta_;    // Statut associe a mmact_ (defaut=MemZS_ProcA)
  int mid_;  // Identificateur zone memoire  courant 
  bool stop_;
  vector<Byte*> fbuff_;      // Vecteur de pointeur de zone memoire pour chaque fibre 
  vector<Byte*> fprocbuff_;   // Vecteur de pointeur de proc_zone_mem pour chaque fibre 
  vector<BRPaquet> vpaq_;   // Vecteur de BRPaquet pour chaque fibre
  vector<Byte*> vprocpaq_;  // Vecteur de pointeur de zone memoire pour donnees traitees de chaque paquet/fibre 
  vector<BRPaqChecker> vpchk_;
  vector<uint_8> vfgok_;    // Vecteur de flag si paquet OK pour chaque fibre
  vector<uint_8> curfc_;    // Vecteur de numero de FrameCounter pour chaque fibre
  vector<uint_8> fcfirst_;  // numero du FrameCounter pour le premier paquet 
  vector<uint_8> ttfirst_;  // TimeTag pour le premier paquet 
  bool fgokallfibers_;      // true -> paquets for all fibers OK
  
  uint_8 totprocnpaq_; 
  SOPHYA::TimeStamp cts_;   // current time stamp, get from MemZoneMgr
  int_8 startdate_;         // Temps de depart cts_.DaysPart() 

  string bpnom_;    // nom du processeur
  int bpid_;        // numero d'identificateur 

  SOPHYA::TimeStamp tmstart_, tmend_;  // definition de la fenetre en temps pour appel de Process()
  bool fgproctimewin_;   // false -> pas de fenetre en temps, Process() appele pour tous les paquets 

  int prtlev_;    // print level 
  uint_8 prtmodulo_;   // print periodicity (modulo) 
};



#endif
