// lecture des fichiers acq de Pittsburgh Dec 2010
// et ecriture des matrices de visi temps-frequence
// > make OBJ=$CMVPROG/obj/ EXE=$CMVPROG/exe/ chanum_1210 svv2mtx2_1210

#include "sopnamsp.h"
#include "machdefs.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fstream>
#include <iostream>
#include <string>

#include "pexceptions.h"
#include "tvector.h"
#include "fioarr.h"
#include "timing.h"

/*
export TACQEXE=~/Reza/TAcq/Objs
./CasA03Dec.csh > CasA03Dec.log 2>&1
*/

//--------------------------- Fonctions de ce fichier   ------------------- 
void usage(void);
void usage(void)
{
cout<<"svv2mtx2_1012 [options] dir : lecture des fichiers acq de Pittsburgh Dec 2010"<<endl
    <<" dir : repertoire ou se trouvent les fichiers d'acq"<<endl
    <<" -D : visi is a duplicated one"<<endl
    <<" -o visi.ppf : nom du ficher ppf pour ecrire la visi temps-frequence"<<endl
    <<" -v v1,v2 : numero de voie acq pour cette visi [1-32]"<<endl
    <<"            on calcule <v1.conj(v2)>"<<endl
    <<" -C : compute and store the complexe conjugated visi"<<endl
    <<"      dans ce cas on calcule <v2.conj(v1)>, le but est d'avoir toujours <E.conj(W)>"<<endl
    <<" -t thr : numero de la thread ayant traite cette visi [0-N]"<<endl
    <<" -r row : numero de la ligne de la matrice acq pour cette visi [0-Nrow["<<endl
    <<" -f freq0 : 1ere frequence en MHz"<<endl
    <<" -T it1,it2 : numero (temps) des fichiers a traiter [it1,it2]"<<endl
    <<"ATTENTION: lancer ce prog depuis le repertoire ou doivent etre ecrits les fichiers de visi"<<endl;
}

//----------------------------------------------------
int main(int narg, char* arg[])
{
  // --- Decodage des arguments et traitement 
  int nmiss_stop = 1000;  // on s'arrete si on a "nmiss_stop" fichiers consecutifs manquants
  string outname = "";
  int numthread = -1, numrow = -1;
  bool dupli = false, doconj = false;
  double freq0 = 0.;
  int vacq1=-1, vacq2=-1;
  int ifilmin=0, ifilmax=99999;

  char c;
  while((c = getopt(narg,arg,"hDCo:t:r:f:T:v:")) != -1) {
    switch (c) {
    case 'v' :
      sscanf(optarg,"%d,%d",&vacq1,&vacq2);
      break;
    case 'D' :
      dupli = true;
      break;
    case 'C' :
      doconj = true;
      break;
    case 'o' :
      outname = optarg;
      break;
    case 't' :
      numthread = atoi(optarg);
      break;
    case 'r' :
      numrow = atoi(optarg);
      break;
    case 'f' :
      freq0 = atof(optarg);
      break;
    case 'T' :
      sscanf(optarg,"%d,%d",&ifilmin,&ifilmax);
      if(ifilmin<0) ifilmin=0;
      break;
    case 'h' :
    default :
      usage(); return -1;
    }
  }
  if(optind>=narg) {usage(); return -1;}
  string indir = arg[optind];

  cout<<"v1="<<vacq1<<" v2="<<vacq2<<" doconj="<<(int)doconj<<endl;
  cout<<"thread="<<numthread<<endl; if(numthread<0) return -2;
  cout<<"numrow="<<numrow<<endl;  if(numrow<0) return -2;
  cout<<"dupli="<<(int)dupli<<endl;
  cout<<"outname="<<outname<<endl; if(outname.size()<=0) return -2;
  cout<<"indir="<<indir<<endl;
  cout<<"freq0="<<freq0<<" MHz"<<endl;
  cout<<"request: file "<<ifilmin<<" to "<<ifilmax<<endl; if(ifilmax<ifilmin) return -3;

  InitTim();

  // --- recherche et comptage des fichiers de visibilites
  // ATTENTION: il peut manquer des fichiers au debut ou dans la sequence
  string flistname = outname; flistname += ".filelist";
  int nfile = 0;
  {
  ofstream flistw(flistname.c_str(), ofstream::out);
  cout<<"writing in file list in: "<<flistname<<" (is_open="<<flistw.is_open()<<")"<<endl;
  if(!flistw) {cout<<"!!!!OPEN failed "<<flistname<<endl; return -4;}

  char str[4096];
  struct stat buffer;
  int ifmin2 = ifilmin, ifmax2 = ifilmax; ifilmax = -1;
  bool foundfirst = false;
  int nmiss = 0;
  for(int ifile=ifmin2; ifile<=ifmax2; ifile++) {
    sprintf(str, "%s/vismtx_%d_%d.ppf",indir.c_str(),numthread,ifile);
    int status = stat(str,&buffer);
    if(!foundfirst && status==0) {
      cout<<"first file found: "<<str<<endl;
      foundfirst = true;
      if(ifile>ifilmin) ifilmin = ifile;
    }
    if(!foundfirst) continue;
    if(ifile<ifilmin) continue;
    if(foundfirst && status!=0) {
      // On fait ca car "stst()" est extremement long si le fichier n'existe pas!
      if(nmiss>nmiss_stop) break;
      nmiss++;
      continue;
    }
    nfile++;
    ifilmax = ifile;
    nmiss = 0;
    flistw << string(str) <<endl;
  }
  
  flistw.close();
  cout<<"Found "<<nfile<<" files from "<<ifilmin<<" to "<<ifilmax<<endl;
  if(nfile==0 || ifilmax<ifilmin) return -5;
  }

  PrtTim("--- End of file number search");

  //--------------------------------------------------------------------
  int rc = 0;
  try {

  ifstream flistr(flistname.c_str(), ofstream::in);
  if(!flistr) {cout<<"!!!!OPEN failed "<<flistname<<endl; return -6;}

  // --- read visibility files
  TMatrix< complex<r_4> > MVisi;
  TVector<r_8> MeanTT(nfile);
  TVector<int_4> Npaqsum(nfile);
  TVector<r_4> Freq;
  string tudeb, tufin;
  double tudeb_day, tufin_day;
  int nfreq = 0;
  int lpmod = nfile/25; if(lpmod<=0) lpmod=1;

  int_4 ntimefill = 0, ntimebad = 0;
  bool foundfirst = true;
  while(!flistr.eof()) {
    // --- Lecture d'une visi elementaire (fichier acq)
    string fname;
    getline(flistr,fname);
    if(fname.size()==0) continue;
    if(ntimefill%lpmod==0) cout<<ntimefill<<" "<<" : "<<fname<<endl;
    TMatrix< complex<r_4> > vismtx;
    try {
      PInPersist pin(fname);
      pin >> vismtx;
    } catch(...) {
      cout<<"ERROR: bad file "<<fname<<endl;
      ntimebad++;
      continue;
    }
    tufin = (string)vismtx.Info()["DATEOBS"];

    // --- Time keeping and number of summed elementary visibilities
    MeanTT(ntimefill) = (double)vismtx.Info()["MeanTT"]/125.e6;
    uint_4 npaqsum = vismtx.Info()["NPAQSUM"];
    Npaqsum(ntimefill) = npaqsum;

    // --- Initialisation purposes for the first read file
    if(foundfirst) {
      foundfirst = false;
      tudeb = tufin;
      printf("Reference Time: tt = %.5f sec, TU = %s\n",MeanTT(0),tudeb.c_str());
      if(numrow>=vismtx.NRows()) {
        cout<<"ERROR: requested numrow="<<numrow<<" => "<<vismtx.NRows()<<endl;
        return -5;
      }
      // Frequency
      nfreq = vismtx.NCols();
      cout<<"vismtx: number of frequencies = "<<nfreq<<endl;
      Freq.ReSize(nfreq); for(int i=0;i<nfreq;i++) Freq(i) = i;
      // allocate visib matrice <f> vs t
      cout<<"allocating visibility matrice ("<<nfile<<","<<nfreq<<") "
          <<nfile*nfreq*sizeof(complex<r_4>)/1.e6<<" Mo"<<endl;
      MVisi.ReSize(nfile,nfreq);
      MVisi = complex<r_4>(0.,0.);
    }

    // Fill time-freq visibility matrix
    for(int c=0;c<nfreq;c++) {
      MVisi(ntimefill,c) = vismtx(numrow,c) / complex<r_4>(npaqsum);
      if(doconj) MVisi(ntimefill,c) = conj(MVisi(ntimefill,c));
    }
    ntimefill++;

  }  // fin boucle sur le fichiers d'acq
  cout<<"ntimefill = "<<ntimefill<<" / "<<nfile<<" , ntimebad="<<ntimebad<<" bad files"<<endl;
  flistr.close();
  string order = "rm -f "; order += flistname;
  system(order.c_str());

  // --- keeping info with visi
  {
  // bricolo en unite de jours depuis le 0/12/2010 a 0h
  int y,m,d,h,mn; double s;
  sscanf(tudeb.c_str(),"%d-%d-%dT%d:%d:%lf",&y,&m,&d,&h,&mn,&s);
  tudeb_day = (double)d + ((double)h + mn/60. + s/3600.)/24.;
  sscanf(tufin.c_str(),"%d-%d-%dT%d:%d:%lf",&y,&m,&d,&h,&mn,&s);
  tufin_day = (double)d + ((double)h + mn/60. + s/3600.)/24.;
  }
  DVList dvl;
  dvl["vacq1"] = vacq1;
  dvl["vacq2"] = vacq2;
  dvl["nth"] = numthread;
  dvl["row"] = numrow;
  dvl["dir"] = indir;
  dvl["dupli"] = (dupli) ? 1: 0;
  dvl["isconj"] = (doconj) ? 1: 0;
  dvl["TUobs_0"] = tudeb;
  dvl["TUobs_N"] = tufin;
  dvl["TUday_0"] = tudeb_day;
  dvl["TUday_N"] = tufin_day;
  dvl["TTag_0"] = MeanTT(0);
  if(ntimefill>0) dvl["TTag_N"] = MeanTT(ntimefill-1);
  dvl["freq0"] = freq0;
  dvl["dfreq0"] = 500./8192.;
  dvl["jfr1"] = 0;
  dvl["jfr2"] = nfreq-1;
  dvl["nfreq"] = nfreq;
  dvl["ngrpfreq"] = 1;
  dvl["ifilmin"] = ifilmin;
  dvl["ifilmax"] = ifilmax;
  dvl["ntimefill"] = ntimefill;
  dvl["ntimebad"] = ntimebad;

  // --- writing visibility matrix to file
  cout<<"writing visibility matrix to file "<<outname<<endl;
  POutPersist pos(outname);
  if(ntimefill>0) {
    TVector<r_8> dum1(MeanTT(Range(0,ntimefill-1)));
    pos.PutObject(dum1,"meantt");
    TVector<int_4> dum2(Npaqsum(Range(0,ntimefill-1)));
    pos.PutObject(dum2,"npaqsum");
    TMatrix< complex<r_4> > dum3(MVisi(Range(0,ntimefill-1),Range(0,MVisi.NCols()-1)));
    dum3.Info() = dvl;
    pos.PutObject(dum3,"visi");
    pos.PutObject(Freq,"ifreq");
  }

  }

  //--------------------------------------------------------------------
  catch(PException& exc) {
    cerr<<" svv2mtx2_1210.cc catched PException "<<exc.Msg()<<endl;
    rc = 77;
  }
  catch (std::exception& sex) {
    cerr<<"\n svv2mtx2_1210.cc std::exception :" 
        <<(string)typeid(sex).name() << "\n msg= "<<sex.what()<<endl;
    rc = 78;
  }
  catch(...) {
    cerr<<" svv2mtx2_1210.cc catched unknown (...) exception  "<<endl; 
    rc = 79; 
  }
  cout<<">>>> svv2mtx2_1210.cc ------- END ----------- RC="<<rc<<endl;
  PrtTim("--- End of job");
  return rc;
}

