#include <stdlib.h>
#include <stdio.h>

#include "pisysdep.h"

#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PIOPTMENU_H 
// #include PIMENUBAR_H 
#include PISTDWDG_H 
#include PIBWDG_H 

#include PIPIXMAP_H 

#include PIFILECHO_H 

#include "ex_dessin.h"


int SysBeep(int n)
{
for(int i=0; i<n; i++)  putchar('\007');
return(0);
}
/*
class PITestWindow : public PIWindow {
public:
	PITestWindow(PIMsgHandler *par);
	~PITestWindow() {}

    PIText text;
    PIButton bouton;
    PIButton bouton2, bouton3;
    PILabel label;
    PIScale scl;
    PIPUMenu  * menu;

};
*/

class PITestApp : public PIApplication {
public:
	PITestApp(int sx, int sy);
	~PITestApp();

	virtual void	Process(long msg, PIMsgHandler* sender, void* data=NULL);

//    PIMenubar * menb;
    PIPDMenu  *m[3];
    PICheckBox * ckb;
    PIText * text;
    PIButton * bouton;
    PIButton * bouton2, * bouton3, * bouton4;
    PILabel * label;
    PIScale * scl;
    PIPUMenu  * menu;
    PIPDMenu * pdm;
    PIOptMenu * opt;

};


/*
PITestWindow::PITestWindow(PIMsgHandler *par)
: PIWindow(par, "Peida", PIWK_normal, 200, 200, 50, 50),
  text(this, "TEXTE", 100, 30, 20,10),
  label(this, "Label", 100, 20, 20,60),
  bouton(this, "OK", 66, 40, 20, 20, 100),
  bouton2(this, "Image", 133, 40, 20, 80, 100),
  bouton3(this, "Menu", 555, 40, 20, 140, 100),
  scl(this, "Scale", 88, 5, 45, 100, 20, 10, 130)
{
  menu = new PIPUMenu((PIMsgHandler *)this, "myMenu");
  menu->AppendItem("DoIt-1", 4401);
  menu->AppendItem("DoIt-2", 4402);
  menu->AppendItem("DoIt-25", 4425);
  menu->AppendItem("DoIt-26", 4426);
  menu->AppendItem("Check-33", 4433);
  menu->AppendItem("Check-33", 4433);

  label.SetBorderWidth(3);
  FinishCreate();
}

*/

PITestApp::PITestApp(int sx, int sy)
: PIApplication(sx, sy)
{
//   menb = new PIMenubar(this, "MyMenubar");
   m[0] = new PIPDMenu((PIMsgHandler *)Menubar(),"File");
   m[0]->AppendItem("Open", 10101);
   m[0]->AppendItem("Close", 10102);
   m[0]->AppendItem("New", 10103);
   m[0]->AppendItem("Quit", 10104);
   m[1] = new PIPDMenu((PIMsgHandler *)Menubar(),"Edit");
   m[1]->AppendItem("Copier", 10201);
   m[1]->AppendItem("Coller", 10202);
   m[1]->AppendItem("Couper", 10203);
   m[2] = new PIPDMenu((PIMsgHandler *)Menubar(),"Operation");
   m[2]->AppendItem("AddItem", 10301);
   m[2]->AppendItem("DelItemName", 10302);
   m[2]->AppendItem("DelItemMsg", 10303);

   AppendMenu(m[0]);
   AppendMenu(m[1]);   
   AppendMenu(m[2]);

  ckb = new PICheckBox(this->MainWin(), "CheckBox", 166, 60, 20, 10, 10);
  text = new PIText(this->MainWin(), "TEXTE", 100, 30, 20,40);
  label  = new PILabel(this->MainWin(), "Label", 140, 20, 20,80);
  bouton = new PIButton(this->MainWin(), "OK", 66, 40, 25, 20, 120);
  bouton2 = new PIButton(this->MainWin(), "Image", 133, 40, 25, 80, 120);
  bouton3 = new PIButton(this->MainWin(), "Test", 233, 40, 25, 140, 120);
  bouton4 = new PIButton(this->MainWin(), "Menu", 555, 40, 25, 200, 120);
  scl = new PIScale(this->MainWin(), "Scale", 88, 5, 45, 100, 20, 10, 150);

  menu = new PIPUMenu((PIMsgHandler *)this, "myMenu");
  menu->AppendItem("DoIt-1", 4401);
  menu->AppendItem("DoIt-2", 4402);
  menu->AppendItem("DoIt-25", 4425);
  menu->AppendItem("DoIt-26", 4426);
  menu->AppendItem("Check-33", 4433);
  menu->AppendItem("Check-33", 4433);

  pdm = new PIPDMenu((PIMsgHandler *)this, "myMenu");
  pdm->AppendItem("Linear", 5601);
  pdm->AppendItem("Log.", 5602);
  pdm->AppendItem("Sqrt", 5603);
  pdm->AppendItem("Expon", 5604);
  pdm->AppendItem("Polyn", 5605);

  opt = new PIOptMenu(this->MainWin(), pdm, 80, 20, 110, 150);

  printf("Debug_PITestApp::PITestApp() MenBarSizeX,Y= %d %d \n", 
         Menubar()->XSize(), Menubar()->YSize());

}

PITestApp::~PITestApp()
{
  delete ckb;
  delete text;
  delete label;
  delete bouton;
  delete bouton2;
  delete bouton3;
  delete bouton4;
  delete scl;
  delete menu;
  delete m[0]; delete m[1]; delete m[2];
//  delete menb;

}

static PIWindow * wp3, *wp2, *wp4;
static PIPixmap * pxm;
static unsigned char  pixels[25000];
static PIFileChooser *pfc;
static bool  fgpxm = false;
static bool  fgt = false;

void
PITestApp::Process(long msg, PIMsgHandler* sender, void* data)
{
  static int x = 0;
  static numsg=8800;

//   SysBeep(1);
  char truc[100];
  sprintf(truc,"< %ld - %d (%d)>",msg,x++, ((PIWdgGen *)sender)->kind());
  this->label->SetLabel(truc);
  if (msg == 133)
    {
    if (!fgpxm)  { wp3->Show();  fgpxm = true; }
    for (int i=0; i<25000; i++)  pixels[i] = random()%32;
    if ((x % 3) == 0)  pxm->SetColMap(CMAP_GREY32);
    if ((x % 3) == 1)  pxm->SetColMap(CMAP_COLRJ32);
    if ((x % 3) == 2)  pxm->SetColMap(CMAP_COLBR32);
    pxm->Refresh();
    }
  if (msg == 233)
    {
    if (fgt) { wp2->Hide();  fgt = false; }
    else { wp2->Show();  fgt = true; }
    }
//  if (msg == 555)   (this->menu)->Show(); 

  if (msg == 10104)  Stop();
  if (msg == 10101)  { pfc->AcceptNewFile(false); pfc->Show(); }
  if (msg == 10103)  { pfc->AcceptNewFile(true); pfc->Show(); }

  if (msg == 10301)  
   { numsg++;    m[1]->AppendItem(text->GetText().c_str(), numsg); }
  if (msg == 10302)  { m[1]->DeleteItem(text->GetText().c_str()); }
  if (msg == 10303)  { m[1]->DeleteItemMsg(atol(text->GetText().c_str())); }

  if (msg == 555)  wp4->Show();
  if ( (msg == 6001) || (msg == 6002) )  wp4->Hide();

  if ((msg > 8000) && data) printf("PITestApp::MenubarReturn: %s \n", data);
  if (msg == 5000)  
    { if (data) printf("PITestApp::Process(5000) : %s \n", (char *)data); 
    else printf("PITestApp::Process(5000) (data=NULL) \n");  }
  if (msg == 66) ckb->SetState(true);
  if ((msg / 100) == 56) printf("PITestApp::Process(%d) : %s \n", (int)msg, (char *)data); 

}

int main()
{
  PITestApp * app;
  app = new PITestApp(300, 200);

  wp2 = new PIWindow(app, "Window-2", PIWK_normal,  150, 150, 250, 250);
  ExBWdg bw(wp2, "BWdg", 150, 150, 0, 0);
//  bw.SetBinding(false, true, true, false);
//  bw.ActivateButton(1);
//  bw.ActivatePtrCross();
//  bw.ActivateKeyboard();

  wp4 = new PIWindow(app, "Window-4", PIWK_dialog,  120, 120, 350, 350);
  PIButton bt1(wp4, "OK", 6001, 40, 20, 10, 80);
  PIButton bt2(wp4, "Cancel", 6002, 40, 20, 60, 80);
  PILabel  lb1(wp4, "Mat_00", 30, 20, 10, 10);
  PIText  tx1(wp4, "A00", 50, 20, 50, 10);  
  PILabel  lb2(wp4, "Mat_11", 30, 20, 10, 40);
  PIText  tx2(wp4, "A11", 50, 20, 50, 40);  

  wp3 = new PIWindow(app, "Window-3", PIWK_normal, 200, 200, 350, 350);
  pxm = new PIPixmap(wp3, "myPixmap", 150, 150, 10, 10);
  
  pxm->SetBinding(true, true, true, true);
  pxm->SetPixmap(pixels, 150, 150);

  //  wp4 = new PIWindow(app, "Open...", PIWK_dialog, 300, 300, 400, 400);

  pfc = new PIFileChooser(app,"FileChooser", 5000); 
  pfc->SetPath("/users/eros/ansari/Images++");


//  Int32 ioNumber = 100;
  app->Run();
  delete app;
  exit(0);
}
