#################################################################
#   ------------ Soft BAORadio --------------
#   ------ Exemple de datacard pour les parametres d'acquisition
#          2009 - 2010 
#################################################################
#####      Variables d'environnement de configuration
## BRACQ_TMPDIR , TMPDIR  : Repertoire de fichiers temporaires (defaut=/tmp/)
## BRACQ_BASEDIR : Base directory (/Raid)
## BRACQ_FIBERIDS : FiberIds   (defaut 1,2,3,4,5,6,7,8)
#################################################################

#   Liste des fibres  - @fibres I[,J,K...]  ou @fibers 
#   @fibers 1,2,3   OU   @fibres 1,2,3
#  Par defaut  @fibres 1 
@fibers 1,2
#   Numero (absolu) d'identification des fibres 
#  Defaut:  @fiberids 1,2,3,4,5,6,7,8
@fiberids 1,2,3,4,5,6,7,8
#  Nom du Repertoire pour les fichiers d'acquisition 
#  Par defaut  @outpathname TstAcq
@outpathname ZB
#  Identification de la source observee
#  Par defaut: rien 
@skysource ngc0000
#   Taille des paquets (en bytes provenant de la carte ADC) 
#  Par defaut  @paqsize 16424 
@paqsize 8192
### Parametres du DMA 
#   Taille des DMA en kb (=1024 bytes) 
#  Par defaut @dmasizekb 32
@dmasizekb 32
#   Parametres du timeout
#   @waitenddma maxkloop_check_enddma maxretry first_maxkloop_check_enddma first_maxretry
#     maxkloop_check_enddma : taille de boucle d'attente de fin DMA, en unite de 1000 (max_loop=1000*maxkloop)
#     first_maxkloop...,first_maxretry : parametres pour le premier DMA (attente debut trigger)
#   Defaut : @waitenddma 1000 3 20000 9
waitenddma 1000 3 20000 9
#   Nombre total (maximum) de fichiers fits produits (/fibre)
#  Par defaut  @nbfiles 1
@nbfiles 3
#   Nombre de blocs (ou zones) MemMgr dans un fichier fits
#  Par defaut  @nblocperfile 10
@nblocperfile 10
#   Mode d'acquisition   
#  Par defaut  @acqmode std
#   Modes standard:  [std=raw2c : 2 channels raw data] [fft2c: fft 2 channels - NOT reordered] 
#                    [ordfft2c : fft 2 channels with software reordering]
#                    [fftshrink=fft2cshrink : FFT 2 chan firmware with shrink - 250/4 MHz]
#                    [hdcorrel : data from FPGA / F.DfgfitsVisiCeschamps correlator ]
#   Autres modes:  raw1c , fft1c , fft1cshrink ,  , ordfft1c  
#                  [nof=std+NoFitsFile] pattern,patnof,fft2cnof ...
@acqmode std
#  Parametres MemmoryManager    @memmgr  NZones,NPaqPerZone 
#  Par defaut  @memmgr  4,128
@memmgr  4,128
#  Parametres traitement au vol optionnnel (monitoring)
#  @monitor  NMean  Step  NMaxBlocProc 
#  Par defaut NoMonitoring   @monitor 512 10 0
@monitor 0  384 4 
########################
#  Reduction des tailles de paquets si cle present
#  @reducpaqsz ReducedSize Offset 
reducpaqsz 1024 0 
########################
#### cartes de controle pour le mode transfert sur Ethernet
#  Liste des machines cibles pour les envois de paquets 
#  @ethrtargets Target1 [ Target2 ... ] 
ethrtargets machine1 machine2 ...
##  Liste de cible pour chaque machine 
#  @ethrtargetsf1 targ1 [targ2 ...]
#  @ethrtargetsf8 targ1 [targ2 ...]
ethrtargetsf1 machine1 machine2 ...
ethrtargetsf2 machine1 machine2 ...
##
#  Activation du mode transfert direct DMA -> Ethernet , sans decoupage/verification en paquet a la source
#  @pci2ethdirect
#  Sur la machine destination, nombre total de liens (connexions) ethernet = NbTotalFibre
#  @ethrnlink 4
ethrnlink 4
#  En mode reception de paquets sur ethernet,  On peut activer la lecture
#   de paquets avec alignement du compteur (FrameCounter) avec la carte @ethrforcesamefc
#  @ethrforcesamefc  maxdiff_paqnum   maxresync
#  Le parametre maxdiff_paqnum (0 par defaut) est la difference maximum entre nombre de 
#  paquets lus sur les differents liens et maxresync (0 par defaut) est le nombre maximum de tentatives 
#  de resynchronisation succesive
#  - force_samefc=false : lecture des paquet sans alignement des FrameCounter 
#  - force_samefc=true : lecture paquets avec alignement des FrameCounter
#    + mode par defaut : maxdiff_paqnum=0, maxresync=0 -> on cherche a aligner FrameCounter sur les 
#    differents liens ethernet 
#    + maxdiff_paqnum>0 : difference maximum de nombre de paquets entre les differents liens
#    + maxresync>0 : Mode de lecture avec resynchronisation du nombre de paquets ,  
#      nombre maxi de resynchronisation 
#  Modes conseilles : false  ;  @ethrforcesamefc 0 0   ;  @ethrforcesamefc 10 0 ;  @ethrforcesamefc 50 0
ethrforcesamefc 0 0 
#####
# En activant la carte suivante, le lecteur (EthernetReader) attend les messages END sur chaque lien 
# avant de terminer l'execuction 
#  @ethrwaitendmsg
ethrwaitendmsg
## No de port TCP/IP   
#  @tcpportid 6912
tcpportid 6912
#  Pour desactiver l'ecriture des fichiers FITS
#  @nosavesigfits
nosavesigfits
######################
### Parametres pour calcul des visibilites 
### Le calcul des visibilites ne peut etre active qu'avec le parametre de ligne de commande de mfacq
#  @visicalc NbPaqMean  NbCalcGrp   NbThrPerCalc
#  - NbPaqMean : nb de paquets moyennes 
#  - NbCalcGrp : Nombre de calculateurs de visibilites s'executant en parallele ds le BRVisCalcGroup
#  - NbThrPerCalc : Nombre de thread dans chaque calculateur ( laisser a 1 de preference ) 
#  Defaut : visicalc 1024  1 1 
visicalc 5000  2 1 
#### Passage en mode Time Interval 
# @visitimeint  deltatime_in_seconds
visitimeint 0.5 
## Activation de remplissage du DataTable des visibilites 
## @visidtable 
## Choix des visibilites (Numero de paires de canaux) a calculer 
#  @visipairs FirstPair NbPairs [OddEvenOnly]
#  Par defaut @visipairs 0 999999999   ( calcul de tout )
#  Exemples pour 4 canaux ( 2 fibres) 
#  @visipairs 0 8  : calcul des 8 premieres visibilites (1,1) (1,2) (1,3) (1,4)  (2,2) (2,3) (2,4)  (3,3)
#  @visipairs 2 6  : (1,3) (1,4) (2,2) (2,3) (2,4)  (3,3)
#  @visipairs 1 8  : (1,2) (1,3) (1,4) (2,2) (2,3) (2,4) (3,3) (3,4)
#  @visipairs 1 8  : (1,2) (1,4) (2,2) (2,3) (3,3) (3,4)
visipairs 0 999999999
##  Binning en frequence lors du calcul (parametre en numero des frequences)
#  @visifreq freqmin freqmax nbinfreq 
#  Defaut: visifreq 0 0 0   (aucun binning, toutes les frequences) 
visifreq 0 0 0
##  Choix format fichiers de sortie pour les visibilites 
#  @visifitsout  OU @visippfout   - defaut PPF 
visifitsout
########################
#  Taux de perte de paquets en simulation / nombre maxi de paquets generes (Sans carte PCIExpress) 
#  @nopcilossrate MaxCount.LossRate     (0<=LossRate<1)  - Defaut MaxCount=0 -> Non limite 
#  MaxCount=Partie_Entiere ,   LossRate=Partie_Fractionnaire
#  Defaut @nopcilossrate 0. 
########################
#   Niveau d'impression 
#  @prtlev Level CounterModulo CounterModulo2
#  CounterModulo2 used for BRVIsibilityCalc
prtlev 0 50000 50 
prtlev 1 50000 50 
