#ifndef  BRANAPARAM 
#define  BRANAPARAM

//--------------------------------------------------------------
// Projet BAORadio - (C) LAL/IRFU  2008-2010
// Classe de gestion des parametres programmes d'analyse 
//--------------------------------------------------------------

#include "machdefs.h"

#include <string>
#include <vector>
#include <iostream>

#include "timestamp.h"

class BRAnaParam {  
public:
  BRAnaParam(uint_4 nmean=1000, uint_4 nzon=4, uint_4 npaqz=128);
  int DecodeArgs(int narg, char* arg[]);
  int Usage(bool fgshort);

  int PaqSizeFromFits();

  uint_8 TotalNPaquets() { return ((imax_-imin_+1)*npaqinfile_/istep_); }

  ostream& Print(ostream& os);

  static int DecodeMiniFitsHeader(const char* filename, uint_4& paqsz, uint_4& npaq, 
                                  bool& fgdatafft, bool& fgsinglechannel, SOPHYA::TimeStamp& tmstart);

  vector<string> dirlist_;
  string action_;
  string outpath_;
  bool fgfitsout_;   // true -> force fichier sortie format FITS (defaut PPF)
 uint_4 imin_, imax_, istep_;
  bool rdsamefc_;    // read paquets with same frame counter 
  uint_4 freqmin_, freqmax_, nbinfreq_;
  uint_4 paqsize_; 
  uint_4 nzones_, npaqinzone_;
  uint_4 npaqinfile_;    // nombre de paquets dans un fichier p
  bool fgdatafft_;  // true -> donnee FFT (provenant du firmware FFT)
  bool fgforceraworfft_; // true force par la ligne de commande fgdatafft_ true or false 
  bool fgsinglechannel_; // true -> un seul canal par fibre (par defaut=2 canaux/fibres)
  bool fgforcesingleortwochan_; // true force par la ligne de commande
  int prtlevel_;
  long int prtmodulo_; 

  uint_4 nmean_;
  // definition intervalle de temps (au lieu du nombre de paquet pour spectres moyennes/visibilites 
  bool fgtimeinterval_;  // true : calcul visibilites/spectres moyens par intervalle de temps (au lieu de nmean)
  double timeinterval_;  // definition de l'intervalle de temps en secondes pour spectres moyens/visibilites 
  uint_4 nbloc_;
 
  uint_4 nbcalgrp_;    // Nb d'objets/threads dans BRVisCalcGroup 
  uint_4 nthreads_;  // Nb de threads pour l'execution parallele ds BRVisibilityCalculator

  uint_4 spec_win_sz_;   // taille de fenetre (temps/no de paquet) pour les spectres
  uint_4 spw_ext_sz_;     // zone de garde en temps / no de paquet pour la fenetre des spectres
  uint_4 nbmax_specwfiles_;  // nb maxi de fichiers de fenetres de spectres sauvees 

  double vmin_,vmax_;   // coupure min-max sur la variance 
  int nbands_,bandfirst_,bandlast_; //bandes en frequences pour mean, variance et cut
  bool fgdtpaq_; //if true fill per per paquet datatable
  bool fgdtms_; //if true fill time avergared/filtered spectral power  datatable

  bool fgfreqfilter_; // if true force median filtering on the frequencies
  uint_4 medhalfwidth_; //half freq window for filtering

  string gainfile_;     // nom du fichier de gain (reponse spectrale)

  // Remplissage DataTable power = f(time) 
  
  // definition fenetre en temps pour le traitement des paquets 
  SOPHYA::TimeStamp proctimestart_; //  temps de debut de la fenetre
  SOPHYA::TimeStamp proctimeend_; //  temps de debut de la fenetre
  double proctimeduration_;  // duree en secondes de la fenetre 
  bool fgtimeselect_;  // vrai -> selection des paquets dans la fenetre en temps  
};

#endif
