// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

/* ---------------------------------------------------------- 
   Programme de lecture / calcul de visibilite multi-canaux 
   BAORadio -   LAL/IRFU      R. Ansari, C. Magneville
   V1 : Nov 2009
   ---------------------------------------------------------- */

// include standard c/c++
#include <iostream>
#include <string>
#include <exception>

// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"
#include "timestamp.h"
#include "strutilxx.h"
#include "tarrinit.h"
#include "histinit.h"

#include "brpaqu.h"
#include "brfitsrd.h"
#include "brproc.h"
#include "brviscalc.h"
#include "brdiskw.h"

#include "branap.h"



//----------------------------------------------------
//----------------------------------------------------
int main(int narg, char* arg[])
{

  TArrayInitiator  _inia;

  int rc = 0;
  try {
    // Decodage parametres 
    BRAnaParam par;
    cout << " ===> visimfib.cc: decoding command line arguments " << endl;
    rc = par.DecodeArgs(narg, arg);
    if (rc) return rc;
    rc = par.PaqSizeFromFits();
    if (rc) return rc;
    par.Print(cout);
    if ((par.action_!="cube3d")&&(par.action_!="vis")&&(par.action_!="viscktt")) {
      cout << " !!! visimfib.cc  BAD action = " << par.action_ << " possible values: vis,viscktt,cube3d" << endl;
      return 5;
    }   

    cout << " ---------- visimfib.cc Start - Action= " << par.action_ << " ------------- " << endl;
    ResourceUsage resu;

    BRPaquet paq(par.paqsize_);
    uint_4 procsz=sizeof(float)*(paq.DataSize()+4);
    if ((par.fgdatafft_)||(par.action_=="cube3d")) procsz = 0;
    cout << " visimfib: Creating MemZoneMgr/processing threads - PaqSz= " << par.paqsize_ 
	 << " ProcPaqSz=" << procsz << endl;

    RAcqMemZoneMgr mmgr(par.nzones_, par.dirlist_.size(), par.npaqinzone_, par.paqsize_, procsz);
    
    BRMultiFitsReader reader(mmgr, par.dirlist_, par.rdsamefc_, par.imin_, par.imax_, par.istep_);
    reader.SetPrintLevel(par.prtlevel_,par.prtmodulo_);

    /*    BRVisibilityCalculator proc(mmgr, par.outpath_, par.nmean_, par.nthreads_);
    proc.SelectFreqBinning(par.freqmin_, par.freqmax_, par.nbinfreq_);  */
    BRVisCalcGroup procg(par.nbcalgrp_, mmgr, par.outpath_, par.nmean_, 0, 999999999, false, par.nthreads_);
    procg.SelectFreqBinning(par.freqmin_, par.freqmax_, par.nbinfreq_);

    if (par.action_ == "viscktt")  procg.ActivateTimeTagCheck(par.TotalNPaquets());
    if (par.fgfitsout_) procg.SetFitsOutput();
    if (par.fgtimeinterval_)  procg.SetTimeIntervalMode(par.timeinterval_);
    procg.SetPrintLevel(par.prtlevel_,par.prtmodulo2_);
    BRFFTCalculator procfft(mmgr, par.fgsinglechannel_);

    // On determine MemZaction pour chaque processeur et le finalizemask en fonction du traitement demande 
    if (par.action_ == "cube3d")  mmgr.SetFinalizedMask((uint_4)MemZS_Saved);
    else {
      MemZStatus mfmask=MemZS_ProcA;
      if (par.fgdatafft_) mfmask=procg.SetMemZAction(MemZA_ProcA);
      else { 
	mfmask=procg.SetMemZAction(MemZA_ProcB);
	procg.SetRawData();
      }
      mmgr.SetFinalizedMask((uint_4)mfmask);
    }

    FitsCubeWriter wrt(mmgr, par.outpath_, par.nbloc_);
    //    BRBaseProcessor proc(mmgr);

    cout << " visimfib: Starting threads (reader procVisi) ... " << endl;
    reader.start();
    if (par.action_ == "cube3d")   wrt.start();
    else  { 
      if (!par.fgdatafft_)  procfft.start(); 
      procg.start();
    }
    usleep(200000);
    reader.join();
    if (par.action_ == "cube3d")  wrt.join();
    else {
      if (!par.fgdatafft_)  procfft.join(); 
      procg.join();
    }
    mmgr.Print(cout);
    cout << resu ; 
  }
  catch (std::exception& sex) {
    cerr << "\n visimfib.cc std::exception :"  << (string)typeid(sex).name() 
	 << "\n msg= " << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " visimfib.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> visimfib.cc ------- END ----------- RC=" << rc << endl;
  return rc;

}


