#ifndef  PCIEWRAP_H_SEEN
#define  PCIEWRAP_H_SEEN
#include "brtypes.h"
#include "machdefs.h"
#include "racqumem.h"
#include "brpaqu.h"
#include <string>
#include "randr48.h"  // Generateur aleatoire SOPHYA pour simulation perte de paquets

/* 
   Classe interface aux fonctions d'I/O PCIExpress 
   pour la carte de reception optique BAORadio
   R. Ansari                        Juin 2008
*/

using namespace std;

/*!
   \class PCIEWException
   \ingroup TAcq

   \brief exception class for PCI-express operations.
*/ 

class PCIEWException {
  public:
  explicit PCIEWException(const char * m) { msg = m; }
  explicit PCIEWException(const string& m) { msg = m; }
  virtual ~PCIEWException() { }
  virtual string const& Msg() const  {return msg;}
  virtual const char* what() {return msg.c_str(); }
 private:
  string msg;
};


// Classe definissant l'interface des operations transfert DMA/PCIExpress 
class PCIEWrapperInterface {
 public:
  // Constructeur - fait l'initialisation
  PCIEWrapperInterface();
  // destructeur - libere la memoire allouee
  virtual ~PCIEWrapperInterface();

  virtual UInt32 TransferSize() = 0;
  virtual void   StartTransfers() { return; };
  virtual Byte*  GetData() = 0;
  virtual UInt64 TotTransferBytes() = 0;    
  virtual void PrintStatus(ostream& os) = 0;
  // Identification de fibres / voies 
  inline void SetFiberNumId(int fibnum=1, int fibid=1)
  { fiber_num_=fibnum;  fiber_id_=fibid; }
  inline int FiberNum() { return fiber_num_; }
  inline int FiberId() { return fiber_id_; }
  // Parametre de controle de la boucle d'attente de fin de DMA (en unite de 1000 pour maxkwedma)
  virtual unsigned long SetMaxWaitEndDMA(unsigned int maxkwedma=1000, unsigned int nretry=3);
protected:
  unsigned long maxwaitenddmaloop_;  // Nombre d'iterations de la boucle d'attente de fin de DMA
  unsigned int maxretryenddma_;      // nombre maxi de tentatives pour terminer le DMA 
  int fiber_num_;                    // numero de fibre sur la machine
  int fiber_id_;                     // identificateur de fibre - numero absolu sur l'ensemble des machines
};

// Classe de test Implementant l'interface PCIEWrapper sans DMA 
class TestPCIWrapperNODMA : public PCIEWrapperInterface {
public:	
  // lossrate_=partie_fractionnaire[lossrate], max_frcount_=partie entiere[lossrate]  
  TestPCIWrapperNODMA(UInt32 sz, double lossrate=0.);
  virtual ~TestPCIWrapperNODMA();

  virtual UInt32 TransferSize() ;
  virtual Byte*  GetData() ;
  virtual UInt64 TotTransferBytes() ;    
  virtual void PrintStatus(ostream& os) ;
  
protected:
  Byte* data_;
  Byte* srcdata_;
  UInt32 size_;
  UInt32 frame_counter_;
  UInt64 timetag_; 	
  UInt64 tottransfer_;
  double lossrate_;
  UInt32 max_frcount_; 
  BRPaqChecker pchk_;
//  FMTRandGen rg_;
  SOPHYA::ThSDR48RandGen rg_;
};

#endif
