/*  ------------------------ Projet BAORadio -------------------- 
    Estimation et soustraction d'avant plan radio 
    R. Ansari , C. Magneville - Juin 2010 
---------------------------------------------------------------  */

#ifndef FGNDSUB_SEEN
#define FGNDSUB_SEEN

#include "machdefs.h"      // SOPHYA .h  
#include "sopnamsp.h"      // SOPHYA .h  
#include <math.h>
#include <iostream>
#include <vector>
#include <string> 

#include "tarray.h"
#include "vector3d.h"
#include "lobe.h"
#include "mdish.h"

#ifndef TF 
#define TF r_4 
#endif

//------------------------------------------------------------------------------------
// Cacarterisation du comportement en loi de puissance des cubes de temperature 
class PowerLawChecker {
public:
  PowerLawChecker(TArray< TF >& skycube);
  void CheckXYMean();

  TArray< TF > skycube_;
};

//------------------------------------------------------------------------------------
// Classe implementant la soustraction des avant-plans sous forme de loi de puissance 
class ForegroundCleaner {
public:
  ForegroundCleaner(Four2DResponse& arrep, Four2DResponse& tbeam, TArray< TF >& skycube, double maxratio=10.);
  void BeamCorrections();
  int FixMeanXYTemp(double T0, double alpha);
  int CleanNegatives(TF seuil=1.e-6);
  int CleanPointSources(double nsigmas=5.);
  // Ajustement d'une droite (a x + b) sur ln(Temp) = f(ln(Freq)) 
  TArray< TF > extractLSSCubeP1(TArray< TF >& synctemp, TArray< TF >& specidx);
  // Ajustement d'une parabole (a x^2 + b x + c) sur ln(Temp) = f(ln(Freq)) 
  TArray< TF > extractLSSCubeP2(TArray< TF >& synctemp, TArray< TF >& specidx);

  Four2DResponse& arrep_;   // Array/Instrument beam response
  Four2DResponse& tbeam_;    // Target beam to which would be corrected using BeamCorrections()
  TArray< TF > skycube_;
  double maxratio_;
  double dx_, dy_;   // taille des pixels (radians) de skycube
  double freq0_, dfreq_;    // 1ere frequence et bin en frequence de skycube_;  
};


#endif
